function paramValue=lirePVParam(fidPath,paramName,TwoDSeqPath)
%function paramValue=lirePVParam(fidPath,paramName,TwoDSeqPath)
%
%extrait les parametres demandes des fichiers method, acqp et reco.
%
%fidPath : [string] : chemin vers le fichier fid
%paramName : [string] : nom du parametre desire
%TwoDSeqPath : [string] : chemin vers le fichier 2dseq
%
%paramValue : [string] : valeur du parametre desire

%variables statiques
persistent dataParsFiles;
persistent lastFidPath;
persistent lastTwoDSeqPath;

%initialisation
if(nargin==2)
    TwoDSeqPath='';
end

paramValue=[];

if(isempty(paramName) || isempty(lastFidPath) || ~strcmp(lastFidPath,fidPath) || ~strcmp(lastTwoDSeqPath,TwoDSeqPath))
	
    %initialisation
    dataParsFiles='';
    
    %chemins vers les fichiers method et acqp
	[dirPath]=fileparts(fidPath);
	matlab_ver=version;
    if (strfind(matlab_ver,'2017'))
        methodPath=[dirPath,'method'];
        acqpPath=[dirPath,'acqp'];
    else
        methodPath=[dirPath,'\method'];
        acqpPath=[dirPath,'\acqp'];
    end
    
	%lecture du fichier method
	fid=fopen(methodPath,'r');
	if(fid<0)
		warning('Fichier [method] introuvable !');
    else
        tmp=textscan(fid,'%s','Delimiter','\n');
        dataParsFiles=[dataParsFiles,lower(cell2mat(tmp{1}'))];
		%fermeture du fichier
		fclose(fid);
    end
    
    %lecture du fichier acqp
	fid=fopen(acqpPath,'r');
	if(fid<0)
		warning('Fichier [acqp] introuvable !');
    else
        tmp=textscan(fid,'%s','Delimiter','\n');
        dataParsFiles=[dataParsFiles,lower(cell2mat(tmp{1}'))];
		%fermeture du fichier
		fclose(fid);
    end
	
    if(~isempty(TwoDSeqPath))
        %chemins vers le fichier reco
        [dirPath]=fileparts(TwoDSeqPath);
        if (strfind(matlab_ver,'2017'))
            recoPath=[dirPath,'reco'];
        else
            recoPath=[dirPath,'/reco'];
        end
        
        %lecture du fichier reco
        fid=fopen(recoPath,'r');
        if(fid<0)
            warning('Fichier [reco] introuvable !');
        else
            tmp=textscan(fid,'%s','Delimiter','\n');
            dataParsFiles=[dataParsFiles,lower(cell2mat(tmp{1}'))];
            %fermeture du fichier
            fclose(fid);
        end
    end
    
	%sauvegarde
	lastFidPath=fidPath;
    lastTwoDSeqPath=TwoDSeqPath;
	
	%si demande d'initialisation
	if(isempty(paramName)); return; end
end

%formatage du parametre
pName=['##$',lower(strtrim(paramName)),'='];

%trouve la position
indParam=strfind(dataParsFiles,pName);
if(isempty(indParam))
	paramValue=[];
	return;
end

%determine la dimension
pDim=sscanf(dataParsFiles(indParam:end),[pName,'( %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d']);

%position de fin de valeur
lenParamVal=strfind(dataParsFiles((indParam+length(pName)):end),'##$');
lenParamVal2=strfind(dataParsFiles((indParam+length(pName)):end),'$$ @vis');
lenParamVal=lenParamVal(1)-1;
lenParamVal2=lenParamVal2(1)-1;
lenParamVal=min(lenParamVal,lenParamVal2);
if(isempty(lenParamVal)); lenParamVal=dataParsFiles((indParam+length(pName)):end); end

%lecture de la valeur du parametre
if(~isempty(pDim))
	%position du debut de la valeur
	indParamVal=strfind(dataParsFiles((indParam+length(pName)):end),')');
	indParamVal=indParamVal(1);
	if(~isempty(indParamVal))
		a=indParam+length(pName)+indParamVal;
		b=a-indParamVal+lenParamVal-1;
        
        %fix for pulse info
        if(b<a)
            pValStr=dataParsFiles((indParam+length(pName)):(indParam+lenParamVal));
        else
            pValStr=dataParsFiles(a:b);
        end
        
	end
else
	%position du debut de la valeur
	indParamVal=indParam+length(pName);
	a=indParamVal;
	b=a+lenParamVal-1;
	pValStr=dataParsFiles(a:b);
end

%tentative de conversion en numeric
pValNum=str2num(pValStr);
if(isnumeric(sum(pValNum)) && ~isempty(pValNum))
	%valeur ok : reshape
	if(~isempty(pDim))
		paramValue=squeeze(reshape(pValNum,[pDim(end:-1:1)',1]))';
	else
		paramValue=pValNum;
	end
else
	%string
	paramValue=pValStr;
end

%warning
if(isempty(paramValue))
	warning(['Le parametre [',paramName,'] est introuvable !']);
end

end
