%function figure_handle =
%GEView_plot_one_gene_exp_sample_gr(sample_gr_cell, sample_grps, exp_vec, gene_name, mean_median_flag, samples)
function GEView_plot_one_gene_exp_sample_gr(sample_gr_cell, sample_grps, exp_vec, gene_symbol, gene_id_short, mean_median_flag, samples, display_samples_flag,subplot_idx,num_of_subplots,anova_title,pval,qval)

red_points_flag = 1;
plot_border_samples_flag = 1;

sample_font_size=5;
font_size = 6;

title_font_size = 9; %was 10
if num_of_subplots>3
    title_font_size=7;
end
marker_points_width= 15;
if isunix
    font_size = 5;
    title_font_size = 6;
end

set(gca, 'FontSize', font_size);

legend_vec = zeros(1,0);
legend_cell = cell(1, 0);
legend_ind = 1;
hold on;
num_gr = length(sample_gr_cell);
mean_val_vec = zeros(1, num_gr);
std_val_vec = zeros(1, num_gr);
gr_num_samples = zeros(1, num_gr);
num_samples_border_exp = 1;
min_val = 10;
max_val = 0;
for i = 1:num_gr
    gr_ind = sample_gr_cell{i};
    if(red_points_flag)
        plot(repmat(i, size(gr_ind)), exp_vec(gr_ind), '.r', 'markersize', marker_points_width);
    end
    max_val = max(max_val, max(exp_vec(gr_ind)));
    min_val = min(min_val, min(exp_vec(gr_ind)));
    gr_num_samples(i) = length(gr_ind);
    if(mean_median_flag==1) % mean
        mean_median_str = 'mean';
        std_mad_str = 'std';
        mean_val_vec(i) = mean(exp_vec(gr_ind));
        std_val_vec(i) = std(exp_vec(gr_ind));
    elseif(mean_median_flag==2) % median
        mean_val_vec(i) = median(exp_vec(gr_ind));
        %        std_val_vec(i) = (1/norminv(0.75))*mad(exp_vec(gr_ind));
        %std_mad_str = ['1.4826*mad'];
        std_val_vec(i) = std(exp_vec(gr_ind));
        mean_median_str = 'median';
        std_mad_str = ['std'];
        
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % plot names of samples with highest/lowest expression
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if num_gr==2
        x_loc=i+0.08;
    else   
        x_loc=i+0.12; %0.4/num_gr;
    end
    if display_samples_flag==1 %plot only min and max exp
        [~, ind_sorted] = sort(exp_vec(gr_ind));
        if(plot_border_samples_flag)
            highest_samples_ind = gr_ind(ind_sorted(end-num_samples_border_exp+1:end));
            lowest_samples_ind = gr_ind(ind_sorted(1:num_samples_border_exp));
            
            
            for j = 1:num_samples_border_exp
                text(x_loc, str2num(num2str(exp_vec(highest_samples_ind(j)))), ...
                    erase_backslash(samples{highest_samples_ind(j)}), 'fontsize', sample_font_size);
                text(x_loc, str2num(num2str(exp_vec(lowest_samples_ind(j)))), ...
                    erase_backslash(samples{lowest_samples_ind(j)}), 'fontsize', sample_font_size);
            end
        end
    elseif display_samples_flag==2 %plot all samples
        for j = 1:length(gr_ind)
                text(x_loc, str2num(num2str(exp_vec(gr_ind(j)))), ...
                    erase_backslash(samples{gr_ind(j)}), 'fontsize', sample_font_size);
        end     
    end
end
v = axis; x_len = v(2)-v(1);
line_width = x_len/(num_gr*8);
if display_samples_flag==3 %plot no sample names, 12/2016
    line_width=line_width*2;
end
%line_width = x_len/(num_gr*3); THIS WAS in the PAPER probably
std_line_width = 1.6;
mean_line_width = 3;
for i = 1:num_gr
    % plot mean or median
    handle_mean = plot([i-line_width i+line_width], [mean_val_vec(i) mean_val_vec(i)], 'k', 'LineWidth', mean_line_width);
    hold on;
    % plot std or mad*    % plot mean or median
    mean_minus_std_vec=mean_val_vec(i)-std_val_vec(i);
    mean_plus_std_vec=mean_val_vec(i)+std_val_vec(i);
    max_val = max(max_val, mean_plus_std_vec);
    min_val = min(min_val, mean_minus_std_vec);
    handle_std = plot([i-line_width i+line_width], [mean_minus_std_vec mean_minus_std_vec], ...
        'b', 'LineWidth', std_line_width);
    plot([i-line_width i+line_width], [mean_plus_std_vec mean_plus_std_vec], 'b', ...
        'LineWidth', std_line_width);
    plot([i-line_width i-line_width], [mean_minus_std_vec mean_plus_std_vec],...
        'b', 'LineWidth', std_line_width);
    plot([i+line_width i+line_width], [mean_minus_std_vec mean_plus_std_vec], 'b', ...
        'LineWidth', std_line_width);
    if(i==1)
        legend_vec(legend_ind) = handle_mean;
        legend_cell{legend_ind} = mean_median_str;
        legend_ind = legend_ind+1;
        legend_vec(legend_ind) = handle_std;
        legend_cell{legend_ind} = std_mad_str;
        legend_ind = legend_ind+1;
    end
end
v = axis;
v(2) = num_gr+1;
range = max_val-min_val;
if range==0
    range=1;
end
v(3) = min_val - range/10;
v(4) = max_val + range/10;

axis(v);

if subplot_idx==1
    legend(legend_vec, legend_cell,'Location', 'best');
    ylabel('Log2 Expression', 'FontWeight', 'bold', 'FontSize', 10);
% else
%     set(gca,'yticklabel',[]);
end

if num_of_subplots>3 && display_samples_flag==3
    pq_title=['P=' num2str(pval, 2) ',Q=' num2str(qval, 2)];
else
    pq_title=['P = ' num2str(pval, 2) ', Q = ' num2str(qval, 2)];
end

if num_of_subplots>3 && subplot_idx>1
    title_name = {gene_id_short; pq_title};
else
    if isnan(gene_id_short) %only gene symbols
        title_name = {gene_symbol; [anova_title '  ' pq_title]};
    else
        title_name = {[gene_symbol ' ' gene_id_short]; [anova_title '  ' pq_title]};
    end
end
title(title_name, 'FontSize',title_font_size, 'FontWeight', 'bold','Interpreter','none');

set(gca,'xtick',[]);

num_samples = length(sample_grps);
v=axis; y_len = v(4)-v(3);
for i = 1:num_samples
    sample_gr = char(sample_grps{i});
    str = [erase_backslash(sample_gr(1:min(6, length(sample_gr)))) '(' num2str(gr_num_samples(i)) ')'];
    %    str = [erase_backslash(sample_gr(1:min(6, length(sample_gr)))) ];
    %    text(i, v(3)-y_len/100, str, 'rotation', 270, 'FontSize',font_size, 'FontWeight', 'bold');
    text(i, v(3)-y_len/70, str, 'rotation', 315, 'FontSize',font_size, 'FontWeight', 'bold');
end


