function varargout = geview_app(varargin)
% GEVIEW_APP MATLAB code for geview_app.fig
%      GEVIEW_APP, by itself, creates a new GEVIEW_APP or raises the existing
%      singleton*.
%
%      H = GEVIEW_APP returns the handle to a new GEVIEW_APP or the handle to
%      the existing singleton*.
%
%      GEVIEW_APP('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GEVIEW_APP.M with the given input arguments.
%
%      GEVIEW_APP('Property','Value',...) creates a new GEVIEW_APP or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before geview_app_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to geview_app_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help geview_app

% Last Modified by GUIDE v2.5 10-Jul-2016 18:37:35

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @geview_app_OpeningFcn, ...
                   'gui_OutputFcn',  @geview_app_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before geview_app is made visible.
function geview_app_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to geview_app (see VARARGIN)

% Choose default command line output for geview_app
handles.output = hObject;

handles.batch_param.fdr_q=0.05;
handles.batch_default='';
handles.batch_done=0;
handles.fig_to_delete=nan;
handles.pca_before_filter_figh=nan;
handles.pca_after_filter_figh=nan;


% Update handles structure
guidata(hObject, handles);

% UIWAIT makes geview_app wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = geview_app_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton_help.
function pushbutton_help_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if ispc
    web(fullfile('help','help.htm'),'-browser');
else
    web(fullfile('help','help.htm'));
end

function edit_data_file_Callback(hObject, eventdata, handles)
% hObject    handle to edit_data_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_data_file as text
%        str2double(get(hObject,'String')) returns contents of edit_data_file as a double


% --- Executes during object creation, after setting all properties.
function edit_data_file_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_data_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_results_path_Callback(hObject, eventdata, handles)
% hObject    handle to edit_results_path (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_results_path as text
%        str2double(get(hObject,'String')) returns contents of edit_results_path as a double


% --- Executes during object creation, after setting all properties.
function edit_results_path_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_results_path (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_status_Callback(hObject, eventdata, handles)
% hObject    handle to edit_status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_status as text
%        str2double(get(hObject,'String')) returns contents of edit_status as a double


% --- Executes during object creation, after setting all properties.
function edit_status_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_run.
function pushbutton_run_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_run (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

run_analysis(handles);


% --- Executes on button press in pushbutton_load.
function pushbutton_load_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_load (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

files={'*.txt','Text files (*.txt)';'*.*',  'All Files (*.*)'};
[FileName,PathName] = uigetfile(files, 'Select Data File');
if ~FileName
    return;
end
datFileName=fullfile(PathName,FileName);
[~, handles.in_file]=fileparts(FileName);

%datFileName=strtrim(get(handles.edit_data_file,'string')); 
% if exist(datFileName)~=2
%     errordlg('Data file not found','File Error','modal');
%     return;
% end

set(handles.edit_status,'string','Please wait - loading data file ...');
figure(gcbf);   % Changes the focus to the figure so that the editable text box loses focus
drawnow;      % Forces the editable text box to update and fires the callback immediately
data=my_importdata(datFileName);


if size(data.textdata,2)-size(data.data,2)==2 % Microarray data
    symbols_col=2;
    handles.loaded_data.ids=data.textdata(3:end,1);
    set(handles.checkbox_only_with_gene_symbols,'enable','on');
elseif size(data.textdata,2)-size(data.data,2)==1 %NGS and protein data
    symbols_col=1;
    handles.loaded_data.ids=[];
    set(handles.checkbox_only_with_gene_symbols,'enable','off');
else
    set(handles.edit_status,'string','Idle');
    errordlg('For microarray data - the first column must be probes ids, the second - gene symbols. For NGS and protein data - there must be only one column containing gene symbols or protein names. Please also make sure to replace blank gene symbols by --- (3 consecutive hyphens)',...
        'Invalid Input','modal');
    return;
end

handles.loaded_data.gene_symbols=strtrim(data.textdata(3:end,symbols_col));
handles.loaded_data.samples=data.textdata(1,symbols_col+1:end);
handles.loaded_data.groups_cell=data.textdata(2,symbols_col+1:end);
handles.loaded_data.log2_data=data.data;

if symbols_col==1 %NGS and protein data
    idx=find(strcmp(handles.loaded_data.gene_symbols,'---') | strcmp(handles.loaded_data.gene_symbols,''));
    handles.loaded_data.gene_symbols(idx)=[];
    handles.loaded_data.log2_data(idx,:)=[];
    if length(unique(handles.loaded_data.gene_symbols))<length(handles.loaded_data.gene_symbols)
        set(handles.edit_status,'string','Idle');
        errordlg('For NGS and protein data - gene symbols or protein names must be unique.','GEView Error','modal');
        return;
    end
else % Microarray data
    idx=find(strcmp(handles.loaded_data.ids,'---') | strcmp(handles.loaded_data.ids,''));
    handles.loaded_data.ids(idx)=[];
    handles.loaded_data.gene_symbols(idx)=[];
    handles.loaded_data.log2_data(idx,:)=[];
    if length(unique(handles.loaded_data.ids))<length(handles.loaded_data.ids)
        button1 = questdlg('The probe ids in your input file are not unique. Would you like to proceed anyway?', 'Warning: Probe Ids not unique','Yes','No','No');
        if strcmp(button1,'No') || isempty(button1)
            set(handles.edit_status,'string','Idle');
            return;
        end
    end
end

%trim too long ids and gene symbols
max_cell_length=100;
if ~isempty(handles.loaded_data.ids)
    cell_lengths=cellfun(@length,handles.loaded_data.ids);
    idx=find(cell_lengths>max_cell_length);
    for i=1:length(idx)
        handles.loaded_data.ids{idx(i)}=handles.loaded_data.ids{idx(i)}(1:max_cell_length);
    end
end
cell_lengths=cellfun(@length,handles.loaded_data.gene_symbols);
idx=find(cell_lengths>max_cell_length);
for i=1:length(idx)
    handles.loaded_data.gene_symbols{idx(i)}=handles.loaded_data.gene_symbols{idx(i)}(1:max_cell_length);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if get(handles.radiobutton_raw_data,'value')
    if any(handles.loaded_data.log2_data(:)<=0)
        set(handles.edit_status,'string','Idle');
        errordlg('Raw data must be positive for any value','GEView Error','modal');
        return;
    else
        handles.loaded_data.log2_data=log2(handles.loaded_data.log2_data);
    end
end


groups_cell=handles.loaded_data.groups_cell;
for i=1:length(groups_cell)
    groups_cell{i}=['_' groups_cell{i} '_'];
end

idx=strfind(groups_cell,'_');
number_of_underscores=unique(cellfun('length',idx))-2;
if ~isscalar(number_of_underscores)
    set(handles.edit_status,'string','Idle');
    errordlg('Number of underscores must be identical in all sample labels','File Error','modal');
    return;
end
handles.loaded_data.sample_labels=cell(1,number_of_underscores+1);
for i=1:length(handles.loaded_data.sample_labels) 
    for j=1:length(handles.loaded_data.samples)    
        handles.loaded_data.sample_labels{i}{j}=groups_cell{j}(idx{j}(i)+1:idx{j}(i+1)-1);
    end
end

set(handles.listbox_filtered_samples,'string',{},'userdata',[]);

handles.pca_clicked=0;
handles.filtering_done=0;
handles.after_batch_flag=0;
handles.batch_default='';
handles.batch_done=0;
if ishandle(handles.fig_to_delete)
    delete(handles.fig_to_delete);
    handles.fig_to_delete=nan;
end 
if ishandle(handles.pca_before_filter_figh)
    delete(handles.pca_before_filter_figh);
    handles.pca_before_filter_figh=nan;
end
if ishandle(handles.pca_after_filter_figh)
    delete(handles.pca_after_filter_figh);
    handles.pca_after_filter_figh=nan;
end 

guidata(hObject, handles);

set(handles.edit_status,'string',['Data file ' datFileName ' was loaded']);
set(handles.edit_data_file,'string',datFileName);
set(handles.edit_data_file,'tooltipstring',datFileName);

msgbox(['Data file ' datFileName ' was loaded'],'Data loaded','modal');

% --- Executes on button press in pushbutton_pca.
function pushbutton_pca_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_pca (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if ~isfield(handles,'loaded_data')
    errordlg('Please load a data file','GEView Error','modal');
    return;
end

before_filtering=isempty(get(handles.listbox_filtered_samples,'string'));

if before_filtering
    if ishandle(handles.pca_before_filter_figh)
        errordlg('You already clicked PCA for the filtering stage. Please use your current PCA figure.','GEView Error','modal');        
        return;
    else %~isempty(get(handles.listbox_filtered_samples,'userdata'))
        %errordlg('The PCA and filtering stage was done. Please reload your data or go to the next step.','GEView Error','modal');
        [err1, hfig]=plot_pca(1000, handles, 1, 1, 'PCA before filtering');     
        handles.pca_before_filter_figh=hfig;
        guidata(hObject, handles);
        if ~isempty(err1)
            errordlg(err1,'GEView Error','modal');
        end
        return;
    end
else
    if ~handles.filtering_done
        listbox_sample_numbers=get(handles.listbox_filtered_samples,'userdata');
        if ~isempty(listbox_sample_numbers) %sample filtering
            handles.loaded_data.groups_cell(listbox_sample_numbers)=[];
            handles.loaded_data.samples(listbox_sample_numbers)=[];
            handles.loaded_data.log2_data(:,listbox_sample_numbers)=[];
            for i=1:length(handles.loaded_data.sample_labels)
                handles.loaded_data.sample_labels{i}(listbox_sample_numbers)=[];
            end
            handles.filtering_done=1;
        end
    end
    
    if ishandle(handles.pca_before_filter_figh)
        %delete(handles.pca_before_filter_figh)
        set(handles.pca_before_filter_figh,'userdata','Filtering was already done.');
        handles.fig_to_delete=handles.pca_before_filter_figh;
        handles.pca_before_filter_figh=nan;
    end
    
    [~, hfig]=plot_pca(1000, handles, 1, 0, 'PCA after filtering');
    handles.pca_after_filter_figh=hfig;
    
    guidata(hObject, handles);
    
end


% --- Executes on selection change in listbox_filtered_samples.
function listbox_filtered_samples_Callback(hObject, eventdata, handles)
% hObject    handle to listbox_filtered_samples (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox_filtered_samples contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox_filtered_samples


% --- Executes during object creation, after setting all properties.
function listbox_filtered_samples_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox_filtered_samples (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_batch_correction.
function pushbutton_batch_correction_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_batch_correction (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if ~isfield(handles,'loaded_data')
    errordlg('Please load a data file','GEView Error','modal');
    return;
end

if handles.batch_done
    errordlg('Batch correction was already done.','GEView Error','modal');
    return;
end

if ~handles.filtering_done
    listbox_sample_numbers=get(handles.listbox_filtered_samples,'userdata');
    if ~isempty(listbox_sample_numbers) %sample filtering
        handles.loaded_data.groups_cell(listbox_sample_numbers)=[];
        handles.loaded_data.samples(listbox_sample_numbers)=[];
        handles.loaded_data.log2_data(:,listbox_sample_numbers)=[];
        for i=1:length(handles.loaded_data.sample_labels)
            handles.loaded_data.sample_labels{i}(listbox_sample_numbers)=[];
        end
        handles.filtering_done=1;
    end   
end

%[batch_err, batch_struct]= prepare_batch_correction(handles.loaded_data.sample_labels);
%prepare Combat
if length(handles.loaded_data.sample_labels)<2
    errordlg('Batch label is not found.','GEView Error','modal');
    return;
end

batch_labels=handles.loaded_data.sample_labels{2};

batch_grps=unique(batch_labels);
if length(batch_grps)==1
    errordlg('There must be at least 2 batches.','GEView Error','modal');
    return;
end

batchIdx=zeros(size(batch_labels));
for i=1:length(batch_grps)
    batchIdx(strcmp(batch_labels,batch_grps{i}))=i;
end

batch_gr_cell=cell(size(batch_grps));

for i=1:length(batch_grps)
    batch_gr_cell{i}=find(strcmp(batch_grps{i},batch_labels));
end

batch_sizes=cellfun('length',batch_gr_cell);
if min(batch_sizes)<2
    errordlg('Each batch must contain at least 2 samples.','GEView Error','modal');
    return;
end
%%%%%%%%%%%%%%%%%%%%

if exist('input_for_R.mat')==2
    delete('input_for_R.mat');
end
if exist('data_after_combat.mat')==2
    delete('data_after_combat.mat');
end
dataForCombat=handles.loaded_data.log2_data;
save input_for_R.mat dataForCombat batchIdx

message1=['GEView is about the launch ComBat batch correction from R. Would you like GEView to search for R installation path? ' ...
    '(if you answer "No", then you will be asked to supply this folder)'];

button1 = questdlg(message1,'R Installation Folder','Yes','No...','Cancel','Yes');
if strcmp(button1,'Cancel') || isempty(button1)
    return;
elseif strcmp(button1,'Yes')
    if ispc
        R_exe_folder=FindRpath;
        if isempty(R_exe_folder)
            errordlg('GEView could not find your R path. Please verify the R is installed or enter the path manually.','GEView Error','modal');
            return;
        end
    else
        R_exe_folder='';
    end
else
    R_exe_folder = inputdlg(['Please enter the R executable location path. On Windows, this path ' ...
        'can be found by right-clicking on the R icon, choosing Properties, and looking '...
        'at the Target field. For example: "C:\Program Files\R\R-3.0.1\bin\x64"'], 'Enter R Executble Path');
    if isempty(R_exe_folder)
        return;
    else
        R_exe_folder=R_exe_folder{1};
        if R_exe_folder(1)=='"'
            R_exe_folder=R_exe_folder(2:end-1);
        end
    end
end

R_exe_location=['"' fullfile(R_exe_folder,'R') '"'];
set(handles.edit_status,'string','Running ComBat batch correction ...');
figure(gcbf);   % Changes the focus to the figure so that the editable text box loses focus
drawnow;      % Forces the editable text box to update and fires the callback immediately

system([R_exe_location ' --vanilla < run_combat.R'],'-echo');

delete('input_for_R.mat');

if exist('data_after_combat.mat')~=2
    set(handles.edit_status,'string','Idle');
    errordlg('There was an error while running ComBat. It has not finished.','GEView Error','modal');
    return;
end
load('data_after_combat.mat');
handles.loaded_data.log2_data=combat_res;
delete('data_after_combat.mat');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%
handles.after_batch_flag=1;
handles.batch_done=1;

if ishandle(handles.pca_before_filter_figh)
    %delete(handles.pca_before_filter_figh)
    set(handles.pca_before_filter_figh,'userdata','You should use the newly opened figure for filtering');
    handles.fig_to_delete=handles.pca_before_filter_figh;
    handles.pca_before_filter_figh=nan;
end

[err1, hfig]=plot_pca(1000, handles, 1, ~handles.filtering_done,'PCA after batch correction');
if ~handles.filtering_done
    handles.pca_before_filter_figh=hfig;
end
if ~isempty(err1)
    errordlg(err1,'GEView Error','modal');
    return;
end
guidata(hObject, handles);

set(handles.edit_status,'string','ComBat batch correction completed');
disp('ComBat Batch correction completed');
msgbox('ComBat Batch correction was completed. Please have a look at the new PCA figure.','Batch Correction Completed','modal');


% --- Executes on selection change in popupmenu_display_samples_in_fig.
function popupmenu_display_samples_in_fig_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_display_samples_in_fig (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu_display_samples_in_fig contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_display_samples_in_fig


% --- Executes during object creation, after setting all properties.
function popupmenu_display_samples_in_fig_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_display_samples_in_fig (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --------------------------------------------------------------------
function menu_batch_param_Callback(hObject, eventdata, handles)
% hObject    handle to menu_batch_param (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --- Executes when selected object is changed in uibuttongroup_input_type.
function uibuttongroup_input_type_SelectionChangedFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in uibuttongroup_input_type 
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in checkbox_only_with_gene_symbols.
function checkbox_only_with_gene_symbols_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_only_with_gene_symbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_only_with_gene_symbols
