function [err1, hfig]=plot_pca(filter_num, handles, label_num_default, filtering_allowed_flag, fig_title)

err1='';

if handles.after_batch_flag
    if filtering_allowed_flag
        fig_title='PCA after batch correction';
    else
        fig_title='PCA after filtering and batch correction';
    end
end

log2_data_for_pca=handles.loaded_data.log2_data;

if size(log2_data_for_pca,1)>filter_num %genes filtering
    vi = var(log2_data_for_pca,[],2);
    [~,idx]=sort(-vi);
    idx=idx(1:filter_num);
    log2_data_for_pca=log2_data_for_pca(idx,:);
end

samples=handles.loaded_data.samples;
listbox_filtered_samples_h=handles.listbox_filtered_samples;
sample_labels=handles.loaded_data.sample_labels{label_num_default};

[~, unique_color_idx, color_idx]=unique(sample_labels);

if length(unique_color_idx)>64
    err1='Too many groups for label 1';
    return;
end


PCA_COEFF = princomp(log2_data_for_pca');

proj=log2_data_for_pca'*PCA_COEFF(:,1:3);

hfig=figure('visible','off');
set(findall(hfig,'ToolTipString','Insert Colorbar'),'Visible','Off');
set(findall(hfig,'ToolTipString','Insert Legend'),'Visible','Off');

clrmp = colormap('lines');

pnt=nan(length(samples),1);
%pnt=uimenu_h_vec;

hold on;
for i=1:length(samples)
    pnt(i)=plot3(proj(i,1),proj(i,2),proj(i,3),'.','markersize',30,'color',clrmp(color_idx(i),:));
    p_menu_hand = uicontextmenu('Tag', ['p_menu' num2str(i)]);
    udata.sample_number=i;
    uimenu(p_menu_hand, 'Label', ['Remove ' samples{i}], ...
        'Callback', {@remove_sample,proj(i,:)},'userdata',udata);
    set(pnt(i),'UIContextMenu', p_menu_hand);
end



grid on;
axis equal tight;
title(fig_title);
xlabel('PCA 1');
ylabel('PCA 2');
zlabel('PCA 3');
legend(pnt(unique_color_idx),sample_labels(unique_color_idx),'Location', 'best');
view(2);


export_menu_hand = uicontextmenu;
uimenu_hs=nan(length(handles.loaded_data.sample_labels),1);
for i=1:length(uimenu_hs)
    uimenu_hs(i) = uimenu(export_menu_hand, 'Label', ['Label ' num2str(i)], 'Callback', {@change_color,i});
end

set(gca,'UIContextMenu',export_menu_hand);

set(hfig,'visible','on');


    function remove_sample(uimenu_h,var2,vec)
        
        userdata1=get(gcf,'userdata');
        if ~isempty(userdata1)
            errordlg(userdata1,'GEView Error','modal');
            return;
        end
        
        if ~filtering_allowed_flag
            if handles.after_batch_flag
                errordlg('Filtering samples can be done only once, before or after batch correction, but not both','GEView Error','modal');
            else
                errordlg('Filtering can be done only once','GEView Error','modal');
            end
            return;
        end
        
        label1=get(uimenu_h,'Label');
        udata1=get(uimenu_h,'userdata');
        sample_number=udata1.sample_number;
        
        
        if label1(1)=='R' %remove
            set(listbox_filtered_samples_h,'string',[get(listbox_filtered_samples_h,'string');samples{sample_number};]);
            %set(listbox_filtered_samples_h,'value',[]);
            set(listbox_filtered_samples_h,'userdata',[get(listbox_filtered_samples_h,'userdata');sample_number]);
            h=text(vec(1),vec(2),vec(3),'  Removed', 'HitTest', 'off');
            udata1.text_h=h;
            set(uimenu_h,'Label',['Add ' samples{sample_number}],'userdata',udata1);
            if length(find(strcmp(samples,samples{sample_number})))>1
                warnrdlg(['Sample name '  samples{sample_number} ' is not unique'],'Warning','modal');
            end
        else %add
            delete(udata1.text_h);
            set(uimenu_h,'Label',['Remove ' samples{sample_number}]);
            listbox_sample_numbers=get(listbox_filtered_samples_h,'userdata');
            idx=find(listbox_sample_numbers==sample_number);
            listbox_sample_numbers(idx)=[];
            set(listbox_filtered_samples_h,'userdata',listbox_sample_numbers);
            listbox_samples=get(listbox_filtered_samples_h,'string');
            listbox_samples(idx)=[];
            set(listbox_filtered_samples_h,'string',listbox_samples);
            %set(listbox_filtered_samples_h,'value',[]);
        end
        
    end

    function change_color(var1, var2, label_num)
        sample_labels=handles.loaded_data.sample_labels{label_num};
        [~, unique_color_idx, color_idx]=unique(sample_labels);
        if length(unique_color_idx)>64
            errordlg(['Too many groups for label ' num2str(label_num)],'GEView Error','modal');
            return;
        end
        for i=1:length(samples)
            set(pnt(i),'color',clrmp(color_idx(i),:));
        end
        legend(pnt(unique_color_idx),sample_labels(unique_color_idx),'Location', 'best');
    end
   
end




