%function GEView_plot_and_save_genes_exp_gr(log2_data, ids, gene_symbols, res_path, mean_median_flag, sample_gr_cell, sample_grps, samples, P_vec)
function GEView_plot_and_save_genes_exp_gr(log2_data, ids, gene_symbols, res_path, mean_median_flag, sample_gr_cell, sample_grps, samples, P_vec, Q_vec, handles_edit_status, display_samples_flag)

if length(sample_grps)==2
    anova_title='t-test';
else
    anova_title='ANOVA';
end

num_of_probesets = length(gene_symbols);
extention = '.png';
visibility = 'off';
if ~isempty(ids)
    [genes, ~, J] = unique(gene_symbols);
else
    genes=gene_symbols;
end
num_genes = length(genes);
t1=clock;
for g = 1:num_genes
    if mod(g,10)==0
        minutes_to_finish=ceil(etime(clock,t1)/600*(num_genes-g));
        per_completed=floor((g-1)*100/num_genes);
        set(handles_edit_status,'string',['Running: Completed ' num2str(per_completed) '% out of ' num2str(num_of_probesets) ' probe sets, ' num2str(minutes_to_finish) ' minutes remaining  ...']);
        figure(gcbf);   % Changes the focus to the figure so that the editable text box loses focus
        drawnow;      % Forces the editable text box to update and fires the callback immediately
        t1=clock;
    end
    if ~isempty(ids)
        ind = find(J==g);
    else
        ind=g;
    end
    num_ind = length(ind);
    if(num_ind)
        figure_handle = figure('Visible', visibility);
        if length(sample_grps)<10
            if(num_ind < 7)
                width = min(400*num_ind, 400*3);
            else
                width = 200*num_ind;
            end
            if display_samples_flag==3 %plot no sample names, 12/2016
                width=width/2;
                height=260;
            else
                height = 350;
            end
        else %at least 10 groups
            if(num_ind < 4)
                width = min(500*num_ind, 500*3);
            else
                width = 400*num_ind;
            end        
            height = 350;         
        end
        set(figure_handle,'position',[20 20 width height]);
    end
    plot_vec = zeros(1, num_ind);
    for j = 1:num_ind
        
        i = ind(j);
        plot_vec(j) = subplot(1,num_ind, j);
        
        gene_symbol = gene_symbols{i};
        gene_symbol = gene_symbol(1:min(length(gene_symbol), 15));
        if ~isempty(ids)
            gene_id = ids{i};
            gene_id_short = ['(' gene_id(1:min(length('200012_x_at')+2, length(gene_id))) ')'];
            %gene_name = [gene_symbol ' (' gene_id_short ')'];
        else
            %gene_name=gene_symbol;
            gene_id_short=nan;
        end

%         
%         full_name_flag = 1;
%         if(j>1)
%             full_name_flag = 0;
%         end
%         
%         if(full_name_flag)
%             gene_name = erase_backslash(gene_name);
%         end
        
        GEView_plot_one_gene_exp_sample_gr(sample_gr_cell, sample_grps, ...
            log2_data(i,:), gene_symbol,gene_id_short, mean_median_flag, samples, display_samples_flag,j,num_ind,anova_title,P_vec(i),Q_vec(i));
        
    end
    if(num_ind > 1)
        for j = 1:num_ind
            left_start = 0.1;
            total_height = 0.78;
            len = 0.88;
            bottom_line =  0.12;
            if isunix
                left_start = 0.15;
                total_height = 0.75;
                len = 0.83;
                bottom_line =  0.16;
            end
            if display_samples_flag==3
                total_height=0.75;
            end
            set(plot_vec(j),'position',[left_start+(j-1)*len/num_ind    bottom_line     len/num_ind   total_height]);
        end
    end
    for j = 1:num_ind
        i = ind(j);
        if ~isempty(ids)
            gene_id = erase_slash(ids{i});
        else
            gene_id=['fig' num2str(g)];
        end
        
        f_name = [gene_id extention];
        GEView_prepare_and_save_fig_html(f_name, res_path, figure_handle, width, height);
    end
    close(figure_handle);
end