/*-------------------------------------------------------------------------------------
  The CTRW software is produced by Brian Berkowitz, Weizmann Institute of Science.
  Permission to use the CTRW software is hereby granted to non-profit educational
  and research institutions, for educational and research purposes only, provided
  and as long as this Notice appears.

  THE CTRW SOFTWARE IS BEING DEVELOPED AS A TOOL FOR SCIENTIFIC RESEARCH. HENCE IT
  IS NOT PRESENTED AS ERROR FREE, ACCURATE, COMPLETE, OR USEFUL FOR ANY SPECIFIC
  APPLICATION, AND THE WEIZMANN INSTITUTE MAKES NO WARRANTY OR REPRESENTATION THERETO.

  THE WEIZMANN INSTITUTE SHALL NOT BE LIABLE FOR ANY CLAIMS, DEMANDS, LIABILITIES,
  COSTS, LOSSES, DAMAGES OR EXPENSE OF WHATSOEVER KIND OR NATURE CAUSED TO OR SUFFERED
  BY ANY PERSON OR ENTITY THAT DIRECTLY OR INDIRECTLY ARISE OUT OR RESULT FROM THE USE
  OF THE CTRW SOFTWARE OR IN CONNECTION THEREOF.

  For usage by and for commercial entities please contact Brian Berkowitz.
--------------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------
 Module:        /home/georg/CTRW/ctrw/epm.c
 Author:        G. Kosakowski   g.kosakowski@gmx.net
 Project:       ctrw-lib
 State:         finished and untested
 Creation Date: 10.07.2000
 Description:   calculate advection-dispersion equation after ogata & banks 1961
------------------------------------------------------------------------*/



#include "./ctrw.h"


double erfc(double x);


/*------------------------------------------------------------------------
 Procedure:     epm ID:1
 Purpose:       calculate advection-dispersion equation after ogata & banks 1961

 Input:         Ltransport length (input)
                P Peclet number (input)
                u transport velocity (input)
                x time (input)
 Output:        C Concentration
 Errors:        none
------------------------------------------------------------------------*/
double epm1d (double L, double P,double u, double x){

  double C,T;


  T=u*x/L;
  C=0.5*( erfc(sqrt(P/(4*T))*(1-T)) + exp(P)*erfc(sqrt(P/(4*T))*(1+T)) );
  return(C);
}

double erfc (double xy){
  return (1.0-erf(xy));
}

/*------------------------------------------------------------------------
 Procedure:     ade1d ID:1
 Purpose:       calculate 1d solution for advection-dispersion-equation
                after Bear, Dynamics of fluids in porous media, equ. 10.6.22, page 630
 Input:         x transport length
                D Dispersion
                u velocity (q/n   specific discharge / porosity)
                t time
 Output:        CConcentration
 Errors:        negative values are not allowed....take positive values
------------------------------------------------------------------------*/
double ade1d (double x, double D, double u, double t){
   double C;

	C=0.5*( erfc((x-u*t)/(2*sqrt(D*t))) + exp(x*u/D)*erfc( (x+u*t)/(2*sqrt(D*t)) ) ) ;

   return (C);
   }
