/*-------------------------------------------------------------------------------------
The CTRW software is produced by Brian Berkowitz, Weizmann Institute of Science.
Permission to use the CTRW software is hereby granted to non-profit educational
and research institutions, for educational and research purposes only, provided
and as long as this Notice appears.

THE CTRW SOFTWARE IS BEING DEVELOPED AS A TOOL FOR SCIENTIFIC RESEARCH. HENCE IT
IS NOT PRESENTED AS ERROR FREE, ACCURATE, COMPLETE, OR USEFUL FOR ANY SPECIFIC
APPLICATION, AND THE WEIZMANN INSTITUTE MAKES NO WARRANTY OR REPRESENTATION THERETO.

THE WEIZMANN INSTITUTE SHALL NOT BE LIABLE FOR ANY CLAIMS, DEMANDS, LIABILITIES,
COSTS, LOSSES, DAMAGES OR EXPENSE OF WHATSOEVER KIND OR NATURE CAUSED TO OR SUFFERED
BY ANY PERSON OR ENTITY THAT DIRECTLY OR INDIRECTLY ARISE OUT OR RESULT FROM THE USE
OF THE CTRW SOFTWARE OR IN CONNECTION THEREOF.

For usage by and for commercial entities please contact Brian Berkowitz.
--------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------
Module:        /home/georg/CTRW/ctrw/convolution.c
Author:        Georg Kosakowski
Project:       ctrw
State:         unfinished
Creation Date: 23.05.2000
Description:   functions for calculating the convolution of different solutions

------------------------------------------------------------------------*/



#include "./ctrw.h"
/* static definitions for convolution */
double *xvalue;
double *zvalue;
int nvalue=0;


/*------------------------------------------------------------------------
Procedure:     convade1d ID:1
Purpose:       convolution of input_function with ade1d
Input:
Output:
Errors:        none
------------------------------------------------------------------------*/
double convade1d (double x, double D, double u, double time){
	double retvalue,tau,delta_tau,c1;
	double dummy, myold1;
	int i;

	if (nvalue <= 0) {
		if(initconv(1) < 1.0 ){
			printf("Error while reading input data for convolution! \n");
			return 0.0;
		}
	}

	retvalue=0.0;

	tau=time-xvalue[0];
	/*c1=input_data(time-tau);*/
	c1=zvalue[0];
	dummy=c1*ade1d(x,D,u,tau);
	myold1=dummy; /* new myold */

	for(i=1;i<nvalue;i++) {
		tau=time-xvalue[i];
		delta_tau=xvalue[i]-xvalue[i-1];
		/*c1=input_data(time-tau);*/
		c1=zvalue[i];
		dummy=c1*ade1d(x,D,u,tau);
		retvalue+=delta_tau*(dummy+myold1)/2.;   /* integration */
		myold1=dummy; /* new myold */
	}

	return retvalue;
}


/* calculates convolution of two btc's */
/* input_data is used for one curve */
/*------------------------------------------------------------------------
Procedure:     conv_beta ID:1
Purpose:       convolution of input_data with ctrw-function for 0<beta<2
Input:
Output:
Errors:        none
------------------------------------------------------------------------*/
double conv_beta (double t_mean, double beta, double r, double time){
	double retvalue=0.0, myold1, tau, delta_tau, c1, dummy;
	int i;

	if (nvalue <= 0) {
		if(initconv(1) < 1.0 ){
			printf("Error while reading input data for convolution! \n");
			return 0.0;
		}
	}

	tau=time-xvalue[0];

	/*c1=input_data(time-tau);*/
	c1=zvalue[0];
	dummy=c1*FPTD(t_mean,beta,r,tau);
	myold1=dummy; /* new myold */

	for(i=1;i<nvalue;i++) {
	  tau=time-xvalue[i];
	  delta_tau=xvalue[i]-xvalue[i-1];
	  /*c1=input_data(time-tau);*/
	  c1=zvalue[i];
	  dummy=c1*FPTD(t_mean,beta,r,tau);
	  retvalue+=delta_tau*(dummy+myold1)/2.;   /* integration */
	  myold1=dummy; /* new myold */
	}

	return retvalue;
}


/*------------------------------------------------------------------------
Procedure:     initconv ID:1
Purpose:       reads data for convolution from file
Input:         idummy: 1 reads file
0 free memory
Output:
Errors:        returns 0.0 if an error occurs
------------------------------------------------------------------------*/
double initconv(int idummy){
	char *fn = "conv_in.dat";
	char ln[1000];
	int lines, no_of_elem=1,ndum;
	double xdum,zdum;
	FILE *datei;



	if (idummy == 1) {
		printf("Read input file for convolution conv_in.dat\n");
		/* open file */
		datei = fopen(fn,"r");
		if(datei == NULL){
			printf("Could not open file: %s 	\n",fn);
			return 0.0;
		}

		no_of_elem=0;

		while(!feof(datei)){
			fscanf(datei,"%lg %lg",&xdum, &zdum);
			no_of_elem++; /* set counter higher */
		}
		nvalue=no_of_elem;
		/* test if memory is allocated */
		if(!xvalue){
			xvalue=malloc(nvalue * sizeof(double));
			if(!xvalue){
				printf("Allocation error xvalues -aborting.");
				nvalue=0;
				fclose(datei);
				return 0.0;
			}
		}
		else{
			free(xvalue);
			xvalue=malloc(nvalue * sizeof(double));
			if(!xvalue){
				printf("Allocation error xvalues -aborting.");
				nvalue=0;
				fclose(datei);
				return 0.0;
			}
		}
		if(!zvalue){
			zvalue=malloc(nvalue * sizeof(double));
			if(!zvalue){
				printf("Allocation error zvalues -aborting.");
				nvalue=0;
				fclose(datei);
				return 0.0;
			}
		}
		else{
			free(zvalue);
			zvalue=malloc(nvalue * sizeof(double));
			if(!zvalue){
				printf("Allocation error zvalues -aborting.");
				nvalue=0;
				fclose(datei);
				return 0.0;
			}
		}


		rewind(datei); /* rewind because we read the file again */
		no_of_elem=0;
		while(!feof(datei)){
			fscanf(datei,"%lg %lg",&xdum, &zdum);
			no_of_elem++; /* set counter higher */
			/*		    printf("no_of_elem: %i x:%lg y:%lg \n",no_of_elem,xdum,zdum); */

			/* now copy data */
			xvalue[no_of_elem-1]=xdum;
			zvalue[no_of_elem-1]=zdum;
			printf("i: %i nvalue: %i x:%lg y:%lg \n",no_of_elem-1,nvalue,xvalue[no_of_elem-1],zvalue[no_of_elem-1]);

		} /* while end*/
		nvalue=no_of_elem-1;
	} /* end for idummy==1 */
	else { /* idummy != 1 */
		free(xvalue);
		free(zvalue);
		nvalue=0;
	}
	fclose(datei);
	return 1.0;
}






/*------------------------------------------------------------------------
Procedure:     input_data ID:1
Purpose:       for given x value give back y value....
               y value is linearly interpolated from data set values in xvalue,zvalue.

               For now, only myx=xvalue[i] are input, so no interpolation takes place. 

Input:         myx: xvalue
Output:        y values
Errors:        returns -1
------------------------------------------------------------------------
double input_data(double myx){
	int i;

	/* test if data already read 
	if (nvalue <= 0) {
		if(initconv(1) < 1.0 ){
			printf("Error while reading input data for convolution! \n");
			return -1.0;
		}
	}
	/* return boundary values 
	if (myx<xvalue[0]) return 0.0;
	if (myx=xvalue[0]) return zvalue[0];
	if (myx>xvalue[nvalue-1]) return 0.0;
	/* interpolate (linear) 
	for (i=1;i<nvalue;i++){
	  if(myx<=xvalue[i]){
	    return (zvalue[i-1]+(zvalue[i]-zvalue[i-1])*(myx-xvalue[i-1])/(xvalue[i]-xvalue[i-1]));
	  }
	}

	return 0.0;
}
*/
