/* THIS FILE WAS MODIFIED BY GENNADY MARGOLIN ON 20/03/2001 */

/*-------------------------------------------------------------------------------------
  The CTRW software is produced by Brian Berkowitz, Weizmann Institute of Science.
  Permission to use the CTRW software is hereby granted to non-profit educational
  and research institutions, for educational and research purposes only, provided
  and as long as this Notice appears.

  THE CTRW SOFTWARE IS BEING DEVELOPED AS A TOOL FOR SCIENTIFIC RESEARCH. HENCE IT
  IS NOT PRESENTED AS ERROR FREE, ACCURATE, COMPLETE, OR USEFUL FOR ANY SPECIFIC
  APPLICATION, AND THE WEIZMANN INSTITUTE MAKES NO WARRANTY OR REPRESENTATION THERETO.

  THE WEIZMANN INSTITUTE SHALL NOT BE LIABLE FOR ANY CLAIMS, DEMANDS, LIABILITIES,
  COSTS, LOSSES, DAMAGES OR EXPENSE OF WHATSOEVER KIND OR NATURE CAUSED TO OR SUFFERED
  BY ANY PERSON OR ENTITY THAT DIRECTLY OR INDIRECTLY ARISE OUT OR RESULT FROM THE USE
  OF THE CTRW SOFTWARE OR IN CONNECTION THEREOF.

  For usage by and for commercial entities please contact Brian Berkowitz.
--------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------
 Module:        ctrw.h
 Author:        Georg Kosakowski
 Project:       ctrw
 State:
 Creation Date: 22.05.2000
 Modified on:   13.06.2001
 Description:   header file for ctrw

------------------------------------------------------------------------*/



#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI  3.14159265358979323846

/* def from ctrw.c */
double FPTD(double tm, double beta, double r, double time);
double CFPTD(double tm, double beta, double r, double time);
double SCD(double R, double beta, double kapa, double L);
double CSCD(double R, double beta, double kapa, double L);
double MEAN(double beta, double C, double C_1, double t);
double ST_D(double beta, double C, double C_1, double t);
double FPTD01(double tmeff, double beta, double r, double time);
double CFPTD01(double tmeff, double beta, double r, double time);
double SCD01(double R, double beta, double kapa, double L);
double CSCD01(double R, double beta, double kapa, double L);
double FPTD12(double t_mean,  double beta,  double r,  double t);
double CFPTD12(double t_mean,  double beta,  double r,  double t);
double SCD12(double R, double beta, double kapa, double L);
double CSCD12(double R, double beta, double kapa, double L);
double f(double x, double niu);
double cf(double x, double niu);
double xupper(double niu);
double xlower(double niu);
double MyGamma(double y,int ln_flag);
double lgam(double y);


/* def from convolution.c */
/*double input_data(double myx);*/
double conv_beta (double t_mean, double beta, double r, double time);
double convade1d (double x, double D, double u, double time);
/* io and memory management */
double initconv(int i);


/* def from epm.c */
double epm1d (double L, double P,double u, double x);
double erfc(double x);
double ade1d (double x, double D, double u, double t);
