/*-------------------------------------------------------------------------------------
  The CTRW software is produced by Brian Berkowitz, Weizmann Institute of Science.
  Permission to use the CTRW software is hereby granted to non-profit educational
  and research institutions, for educational and research purposes only, provided
  and as long as this Notice appears.

  THE CTRW SOFTWARE IS BEING DEVELOPED AS A TOOL FOR SCIENTIFIC RESEARCH. HENCE IT
  IS NOT PRESENTED AS ERROR FREE, ACCURATE, COMPLETE, OR USEFUL FOR ANY SPECIFIC
  APPLICATION, AND THE WEIZMANN INSTITUTE MAKES NO WARRANTY OR REPRESENTATION THERETO.

  THE WEIZMANN INSTITUTE SHALL NOT BE LIABLE FOR ANY CLAIMS, DEMANDS, LIABILITIES,
  COSTS, LOSSES, DAMAGES OR EXPENSE OF WHATSOEVER KIND OR NATURE CAUSED TO OR SUFFERED
  BY ANY PERSON OR ENTITY THAT DIRECTLY OR INDIRECTLY ARISE OUT OR RESULT FROM THE USE
  OF THE CTRW SOFTWARE OR IN CONNECTION THEREOF.

  For usage by and for commercial entities please contact Brian Berkowitz.
--------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------
 Module:        /home/ctrw/CTRW/ctrw/gamma.c
 Author:        Gennady Margolin
 Project:       ctrw-lib for grace
 State:         working
 Creation Date: 22.05.2000
 Description:   Gamma function from Numerical Recipes

------------------------------------------------------------------------*/


#include "./ctrw.h"

/* this does not work...maybe definition of gamma in math.h? */

double MGamma(double y, int ln_flag) {

	if(ln_flag) return lgamma(y);
	return gamma(y);
}


/* modul: Gamma                                                              */
/*                                                                           */
/* if ln_flag=0 then return Gamma-function, otherwise return ln(Gamma(y)).   */
/*                                                                           */
/* changed from numerical recipes                                           */
/*                                                                           */

double MyGamma(double y, int ln_flag) {
  int i;
  double g, x_pow_i;
  /*  const double PI = 3.14159265358979323846; */
  const static double b[]={.0,
                          -.577191652,
			   .988205891,
			   -.897056937,
			   .918206857,
			   -.756704078,
			   .482199394,
			   -.193527818,
			   .035868343};
  const double x=y-1;
  if(y<=0) {
    printf("Our Gamma-fnctn isn't defined for argument <= 0\n");
    exit(-1);
  }
  if(y<1) {
    if(ln_flag) return log(MyGamma(y+1.,0)/y);
    return MyGamma(y+1.,0)/y;
  }
  if(y<=2) {
    for(i=1, g=1., x_pow_i=x ; i<=8 ; g+=b[i]*x_pow_i, x_pow_i*=x, i++);
    if(ln_flag) return log(g);
    return g;
  }
  // Stirling's approximation:
  g=(y-.5)*log(y)-y+.5*log(2.*PI)+1./12./y-1./360/y/y/y+1./1260/pow(y,5)-1./1680/pow(y,7);
  if(ln_flag) return g;
  return exp(g);
}



