function res = FPTD(param,t);

T = param(1);
beta = param(2);
r = param(3);

if beta < 1
    if beta > 0.99
        beta=0.99;
    elseif beta<0.1
        beta=0.1;
    end
    
    x=(t/T+r).^(-beta);
    x(find(t<=-r*T))=0; % to get zero output.
    tmp=x./(t+r*T);
    tmp(find(t<=-r*T))=0;
    res = f(x,beta)*beta.*tmp;
    
else
    dum1=T*r;
    
    if dum1 <= 0
        res(1:length(t)) = 0;
        return
    end
    
    if beta > 2
        beta=2;
    elseif beta < 1.01
        beta=1.01;
    end
    
    res = f((T-t)/dum1,1/beta)/beta/dum1;
    
end