function res = CSCD(param,L);

R = param(1);
beta = param(2);
kapa = param(3);

if R <= 0       % must be > 0
    res(1:length(L)) = 0;
    return
end

if beta < 1
    if beta > 0.99
        beta=0.99;
    elseif beta < 0.1
        beta=0.1;
    end
    
    x=1+kapa*L/R;
    tmp=1./x;
    tmp(find(x<=0))=0;  % to get zero output for x<=0.
    res = (L > 0).*(x > 0).*cf(L/R.*tmp.^beta,beta) + (L <= 0);
    
else        %    1 < beta < 2
    if kapa < 0       % must be > 0
        res(1:length(L)) = 0;
        return
    elseif kapa == 0
        res = (L < R);   % a unit step
        return
    end
    
    if beta > 2
        beta=2;
    elseif beta < 1.01
        beta=1.01;
    end
    
    niu=1/beta;
    A1=(L*kapa*R^(beta-1)).^(-niu);
    A1(find(L<=0))=0;
    x=(L-R).*A1;
    res = (L > 0).*cf(x,niu)*niu + (L <= 0);
    
end
