%  consts determines the constants of motion from the 
%  parameters of temporal or spatial distributions.
%  [beta C C1] = consts(param, paramtype, D_or_T);

function res = consts(param, paramtype, D_or_T);

scale = param(1);
beta = param(2);
rk = param(3);

if strcmp(paramtype,'FPTD') | strcmp(paramtype,'CFPTD')
    if beta < 1 
        if beta > 0.99
            beta = 0.99;
        elseif beta < 0.1
            beta = 0.1;
        end
        C=scale^beta/D_or_T;
        C1=scale*rk/D_or_T;
    elseif beta > 1
        if beta > 2
            beta = 2;
        elseif beta < 1.01
            beta = 1.01;
        end
        C=(scale*rk)^beta/D_or_T;
        C1=scale/D_or_T;
    end
    
elseif strcmp(paramtype,'SCD') | strcmp(paramtype,'CSCD')
    if beta < 1
        if beta > 0.99
            beta = 0.99;
        elseif beta < 0.1
            beta = 0.1;
        end
        C=D_or_T^beta/scale;
        C1=D_or_T*rk/scale;
    elseif beta > 1
        if beta > 2
            beta = 2;
        elseif beta < 1.01
            beta = 1.01;
        end
        C=D_or_T^beta*rk/scale;
        C1=D_or_T/scale;
    end
end

% if beta ~= param(2)
%     disp('WARNING: consts: the value of beta is out of boundaries and was changed!!');
% end

res = [beta C C1];