clear all;
close all;
clc;

global data; % it's better to make it global rather then pass it as an
             % argument to functions which will be called many times.
data=struct('concentration',{},'time',{},'distance',{},'type',{});                  
datalength=0; % no data initially. Needed for input of many curves.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Preparing the data structure array.

% for now I generate some artificial "data"
t=logspace(0.7,3,50);
L=10;
type='CFPTD';
y=eval([type,'([20 1.4 .2], t)']);

% write the data into the structure:

data(datalength+1:datalength+length(y))=struct('concentration',num2cell(y),...
    'time',num2cell(t),'distance',num2cell(L),'type',type);
datalength=length(data);

% another "data":
clear t L type y;
t=20;
L=linspace(0.1,30,30);
type='CSCD';
y=eval([type,'([11 1.42 .1], L)']);

% write the data into the structure:

data(datalength+1:datalength+length(y))=struct('concentration',num2cell(y),...
    'time',num2cell(t),'distance',num2cell(L),'type',type);
datalength=length(data);

% another "data":
clear t L type y;
t=50;
L=linspace(1,60,25);
type='CSCD';
y=eval([type,'([25 1.38 .07], L)']);

% write the data into the structure:

data(datalength+1:datalength+length(y))=struct('concentration',num2cell(y),...
    'time',num2cell(t),'distance',num2cell(L),'type',type);
datalength=length(data);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Making initial guess. The convenient way to make a guess and also the limiting
%  boundaries of it is to 
%  1. Choose whether it be a guess for (C)FPTD or (C)SCD. Set guesstype to
%  'FPTD', 'CFPTD', 'SCD' or 'CSCD':
guesstype = 'SCD'

%  2. Specify distance (of (C)FPTD) or time (of (C)SCD) for which the guess is made:
DT = 50

%  3. Provide initial guess;
%  For guesstype = '(C)FPTD', guess = [Tm(eff) beta r].
%  For guesstype = '(C)SCD', guess = [R beta kappa].
guess = [10 1.6 .2]

%  4. Provide lower and upper boundaries (lb and ub) of the guesses.
%  Note that the widest possible interval for beta is 0.1 < beta <= 2.
lb=[1 .5 0];             % lower bounds of guesses.
ub=[100 2 1];             % upper bounds.

%  Maximal number of trials with rundom guesses (inside the bounds):
maxtrials=5;

%  the relative error should be less then maxerr in order to stop fitting
%  before making maxtrials trials.
maxerr=2e-3;

% finding the best fit
tic
bestguess = ctrw_multifit(guess, guesstype, DT, lb, ub, maxtrials, maxerr);
toc

% y_guess = lsqDISTR(bestguess, data, guesstype, DT);
% plotting the fits
plot_fittodata(consts(bestguess, guesstype, DT));

% the end.