%  params determines the parameters of temporal or spatial
%  distributions from the constants of motion.
%  [scale beta rk] = params(const, paramtype, DT);

function res = params(const, paramtype, DT);

beta=const(1);
C=const(2);
C1=const(3);

if strcmp(paramtype,'FPTD') | strcmp(paramtype,'CFPTD')
    if beta < 1
        if beta > 0.99
            beta = 0.99;
        elseif beta < 0.1
            beta = 0.1;
        end
        scale = (DT*C)^(1/beta);
        rk = C1/C^(1/beta)*DT^(1-1/beta);
    elseif beta > 1
        if beta > 2
            beta = 2;
        elseif beta < 1.01
            beta = 1.01;
        end
        scale = DT*C1;
        rk = C^(1/beta)/C1*DT^(-1+1/beta);
    end
    
elseif strcmp(paramtype,'SCD') | strcmp(paramtype,'CSCD')
    if beta < 1
        if beta > 0.99
            beta = 0.99;
        elseif beta < 0.1
            beta = 0.1;
        end
        scale = DT^beta/C;
        rk = C1/C*DT^(beta-1);
    elseif beta > 1
        if beta > 2
            beta = 2;
        elseif beta < 1.01
            beta = 1.01;
        end
        scale = DT/C1;
        rk = C/C1*DT^(1-beta);
    end
end

if beta ~= const(1)
    disp('WARNING: params: the value of beta is out of boundaries and was changed!!');
end

res = [scale beta rk];