function plot_fittodata(const);

global data;

ind1=find(strcmp({data.type},'FPTD'));
ind2=find(strcmp({data.type},'SCD'));
ind3=find(strcmp({data.type},'CFPTD'));
ind4=find(strcmp({data.type},'CSCD'));

ydistr=DISTR(const);

if ~isempty(ind1)
    figure;
    loglog([data(ind1).time],[data(ind1).concentration],'r+',...
        [data(ind1).time],ydistr(ind1)./[data(ind1).time],'bh'); grid on;
    ylabel('FPTD');
    xlabel('time');
    legend('data','fit',-1);
end

if ~isempty(ind3)
    figure;
    semilogx([data(ind3).time],[data(ind3).concentration],'r+',...
        [data(ind3).time],ydistr(ind3),'bh'); grid on;
    ylabel('CFPTD');
    xlabel('time');
    legend('data','fit',-1);
end

if ~isempty(ind2)
    figure;
    plot([data(ind2).distance],[data(ind2).concentration],'r+',...
        [data(ind2).distance],ydistr(ind2)./[data(ind2).distance],'bh'); grid on;
    ylabel('SCD');
    xlabel('distance');
    legend('data','fit',-1);
end

if ~isempty(ind4)
    figure;
    plot([data(ind4).distance],[data(ind4).concentration],'r+',...
        [data(ind4).distance],ydistr(ind4),'bh'); grid on;
    ylabel('CSCD');
    xlabel('distance');
    legend('data','fit',-1);
end

% the end.
