% 
%                                  x             infinity 
%                                  /                /
%                                 |                |
%                 cf(x;niu) = 1 - | f(x';niu)dx' = | f(x';niu)dx'
%                                 |                |
%                                /                /
%                                 0                x

function res = cf(x, niu)
k=25; BigNcf=190;
thetac=0.75; eps_cl=0.1; eps_cu=0.01; alphac=0.53;

xup=xupper(niu);
xlo=xlower(niu);

res=zeros(size(x));

indup = find(x > xup);
if ~isempty(indup)
    
    if niu<0.2 
        thetac=0.67;
    end
    
    dum1 = (1-niu)*(niu*x(indup)).^(1/(1-niu)); % the big parameter
    dum2 = 1-thetac*(2*niu^2+7*niu+2)/24./dum1;
    res(indup) = exp(-dum1/niu).*dum2./sqrt(2*pi*dum1);
    
    if niu > 0.87 
        dum2=xup+eps_cu;
        indeps = find((x > xup) & (x+0.0001*eps_cu < dum2));
        if ~isempty(indeps)
            dum1=cf(xup,niu);
            res(indeps) = dum1+(cf(dum2,niu)-dum1)*(x(indeps)-xup)/eps_cu;
        end
    end    
end 

indlo = find(x < min(0, xlo));
if ~isempty(indlo)
    dum1=(-x(indlo)).^(-1/niu);
    n=floor(niu*(.5+k))+1;
    dum3=zeros(length(indlo),n-1);
    dum3(:,1)=dum1(:);
    for j=2:n-1
        %dum3(:,j)=dum1(:).^j;
        dum3(:,j)=dum1(:).*dum3(:,j-1);
    end
    j=(1:n-1)';
    dum2=pi+(dum3*(sin(pi*j/niu).*gamma(j/niu)./gamma(j+1)))';
    dum2=dum2+alphac*dum1.^n*sin(pi*n/niu)*gamma(n/niu)/gamma(n+1);
    res(indlo) = dum2/pi/niu;
    
    if (niu>0.94) 
        dum2=xlo-eps_cl;
        indeps = find((x < min(0, xlo)) & (x-0.0001*eps_cl > dum2));
        if ~isempty(indeps)
            dum1=cf(xlo,niu);
            res(indeps) = dum1+(cf(dum2,niu)-dum1)*(xlo-x(indeps))/eps_cl;
        end
    end
end    


ind = find((x >= min(0, xlo)) & (x <= xup));
if ~isempty(ind)
    %clear dum1;
    dum1=zeros(length(ind),BigNcf);
    dum1(:,1)=(-x(ind))';
    for j=2:BigNcf
        %dum1(:,j)=(-x(ind))'.^j;
        dum1(:,j)=(-x(ind))'.*dum1(:,j-1);
    end
    j=(1:BigNcf)';
    dum2=exp(gammaln(j*niu)-gammaln(j+1));
    dum3 = dum1*(dum2.*sin(pi*j*niu));
    res(ind) = 1+dum3/pi;
end

% end of cf.m
