clear all;
close all;
help lsqcurvefit  % sometimes needed for first run 
                  % to set path to lsqcurvefit.
clc;

%%%%%%%%%%%%%%%%%%%%% here read the data %%%%%%%%%%%%%%%%%%%%%%%
filename='/users2/gennady/BETA_EVOL/ORTHOGONAL/03.05.18.exp3.454590.agr';

ftype='FPTD';
% Distances at which the curve is given:
% L=125; % not used.

curve=1;
i=1;
fid = fopen(filename);
while feof(fid) == 0
    line = fgetl(fid);
    if isempty(line)
        continue
    elseif line(1) == '&'
        
        if curve == 5
            break;
        end
        curve = curve+1;
        i=1;
        clear x y;  % need to have correct length(y).
        
    elseif (line(1) == '0') | (line(1) == '1') |(line(1) == '2') |(line(1) == '3') |(line(1) == '4') |...
            (line(1) == '5') | (line(1) == '6') |(line(1) == '7') |(line(1) == '8') |(line(1) == '9')
        tmp = sscanf(line,'%f');
        x(i) = tmp(1);
        y(i) = tmp(2);
        i = i+1;
    end
end
fclose(fid);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

guess=[1e5 1.4 0.4];       % initial guess
%guess = [8.2744e+04 1.1778 0.3129];
%guess = [9.37e4 1.151 0.354];
lb=[1e2 .7 0];             % lower bounds of guesses.
ub=[1e7 2 1];              % upper bounds.

maxtrials=1;

% x = lsqcurvefit(@fun,x0,xdata,ydata,lb,ub,options)
% optimset('lsqcurvefit')  % shows default options for given function.
% opts=optimset(optimset('lsqcurvefit') ...
%     ,'MaxFunEvals',1000*length(guess) ...
%     ,'TolFun',1e-20 ...
%     ,'TolX',1e-20 ...
%     ,'MaxIter',4000);% ...
%     %,'Diagnostics','on');

trial=0; % must start from zero for the "if" below.
besttrial=trial;
bestguess=guess;
relres=1;
opts=optimset(optimset('lsqcurvefit'),'MaxFunEvals',1000*length(guess)...
    ,'MaxIter',4000,'TolFun',1e-14,'Display','off');
while (trial < maxtrials) & (relres > 1e-3)
    
    if trial
        lb(1)=log10(lb(1));
        ub(1)=log10(ub(1));
        guess=lb+(ub-lb).*rand(size(guess));
        guess(1)=10^guess(1);
        lb(1)=10^lb(1);
        ub(1)=10^ub(1);
    end 
    
    [guess,resnorm] = lsqcurvefit(ftype,guess,x,y,lb,ub,opts);
    trial=trial+1;
    if relres > resnorm/sum(y.^2)
        relres=resnorm/sum(y.^2);
        besttrial=trial;
        bestguess=guess;
    end
    
end

y_guess=eval([ftype,'(bestguess,x)']);

disp([num2str(trial),' trials. The best is #',num2str(besttrial),' and the best guess is']);
disp([' ',num2str(bestguess(1)),'   ',num2str(bestguess(2)),'   '...
        ,num2str(bestguess(3))]);
disp(['Its relative norm of residue is ',num2str(relres)...
        ,' and correlation coefficient is ',num2str((y-mean(y))*(y_guess-mean(y_guess))'...
        /norm(y-mean(y))/norm(y_guess-mean(y_guess)))]); 


%plot(x,y,x,y_guess,'-.r'); grid on;
figure;
loglog(x,y,'+',x,y_guess,'r'); grid on;
% figure;
% loglog(x,1-y,x,1-y_guess,'-.r'); grid on;



