function res = f(x, niu)

k=25;     % relates to number of terms in asymptotic series
theta=0.8; alpha=0.55; % weights of last terms in expansions
eps=0.2;  % length of the linear interpolation interval (>0)

xup=xupper(niu);
xlo=xlower(niu);

res=zeros(size(x));

indup = find(x > xup);
if ~isempty(indup)
    dum1 = (1-niu)*(niu*x(indup)).^(1/(1-niu));
    dum2 = 1+theta*(2-niu)*(2*niu-1)/24./dum1;
    res(indup) = dum1.^(niu-.5).*exp(-dum1/niu).*dum2/sqrt(2*pi)/(1-niu).^niu;
end

indlo = find(x < min(0, xlo));  % 0 is necessary to be sure that we are
% in the case 1<beta<2 and then niu=1/beta;
% otherwise, niu=beta can be very small and
% xlower large positive, which is wrong.
% For beta close to 1 need to interpolate between exact and
% approximate solutions, since they don't converge good:
% I do a linear interpolation between the f values at points
% xlower and xlower-eps=dum1
if ~isempty(indlo)
    dum1=(-x(indlo)).^(-1/niu);
    n=floor(niu*(.5+k))+1;
    dum3=zeros(length(indlo),n-1);
    dum3(:,1)=dum1(:);
    for j=2:n-1
        %dum3(:,j)=dum1(:).^j;
        dum3(:,j)=dum1(:).*dum3(:,j-1);
    end
    j=(1:n-1)';
    dum2=(dum3*(sin(pi*j/niu).*gamma(j/niu)./gamma(j)))';
    dum2=dum2+alpha*dum1.^n*sin(pi*n/niu)*gamma(n/niu)/gamma(n);
    res(indlo) = dum2/pi/niu^2./x(indlo);
    
    if niu > 0.87 
        dum1=xlo-eps;
        indeps = find((x < min(0, xlo)) & (x-0.0001*eps > dum1));
        if ~isempty(indeps)
            dum3=f(xlo,niu);
            res(indeps) = dum3+(f(dum1,niu)-dum3)*(xlo-x(indeps))/eps;
        end
    end
end

res(find(x == 0)) = gamma(niu)*sin(pi*niu)/pi;

ind = find((x >= min(0, xlo)) & (x <= xup) & (x ~= 0));
if ~isempty(ind)
    BigNf=floor(250.+3./(1.01-niu)); % ideally, should be infinity.
    clear dum1;
    dum1=ones(length(ind),BigNf);
    for j=2:BigNf
        %dum1(:,j)=(-x(ind))'.^(j-1);
        dum1(:,j)=(-x(ind))'.*dum1(:,j-1);
    end
    j=(1:BigNf)';
    dum2=exp(gammaln(j*niu)-gammaln(j));
    dum3 = dum1*(dum2.*sin(pi*j*niu));
    res(ind) = dum3/pi;
end

% end of f.m