clear all;
close all;
help lsqcurvefit;
clc;

filename='/users2/gennady/BETA_EVOL/ORTHOGONAL/03.05.14.exp2.909090.agr';
%filename='/users2/gennady/BETA_EVOL/ORTHOGONAL/03.05.16.exp2.454590.agr';
%filename='/users2/gennady/BETA_EVOL/ORTHOGONAL/03.05.18.exp3.454590.agr';

type='FPTD';
% Distances at which the curves are given:
L=25*(1:8);

global data;
data=struct('concentration',{},'time',{},'distance',{},'type',{});                  
datalength=0; % no data initially. Needed for input of many curves.

curve=1;
i=1;
fid = fopen(filename);
while feof(fid) == 0
    line = fgetl(fid);
    if isempty(line)
        continue
    elseif line(1) == '&'
        
        % write the data into the structure:
        %if curve > 4
        data(datalength+1:datalength+length(y))=struct('concentration',num2cell(y),...
            'time',num2cell(x),'distance',num2cell(L(curve)),'type',type);
        datalength=length(data);
        %end
        curve = curve+1;
        i=1;
        clear x y;  % need to have correct length(y).
        
    elseif (line(1) == '0') | (line(1) == '1') |(line(1) == '2') |(line(1) == '3') |(line(1) == '4') |...
            (line(1) == '5') | (line(1) == '6') |(line(1) == '7') |(line(1) == '8') |(line(1) == '9')
        tmp = sscanf(line,'%f');
        x(i) = tmp(1);
        y(i) = tmp(2);
        i = i+1;
    end
end
fclose(fid);

if curve-1 ~= length(L)
    disp('ERROR: not all, or too many distances for (C)FPTDs are given!!!')
end

guesstype = type

DT = 125

guess = [1e5 1.22 .3];
%guess=[121479 1.1654 0.43297]; % best fit for the first file
%guess=[110503 1.1972 0.40644]; % best fit for last 4 lines of the first file
%guess=[101309 1.3585 0.2616];  % best fit for the second file
%guess=[61080  1.6197 0.1916];  % best fit for the third file
%guess=[72972  1.2318 0.26969]; % best fit for last 4 lines of the third file

lb=[1e2 .7 0]; 
ub=[1e7 2 1];

maxtrials=10;

maxerr=1e-2;

% finding the best fit
tic
bestguess = ctrw_multifit(guess, guesstype, DT, lb, ub, maxtrials, maxerr);
toc

plot_fittodata(consts(bestguess, guesstype, DT));

% the end.