function res = L_psi(u,param,funpar)
% ------------------------------------------------------------
% L_PSI
% Calculates the Laplace transform of the $\psi(t)$ function
% for the different models ADE, TPL, ASY, FDE, ETA. 
% 
% RES = L_PSI(U,PARAM,FUNPAR)
%
% u     := Laplace variable
% param := parameters of the psi function
% funpar:= string specifying the model
% res   := values of the function $\psi(t)$
% 
% Usage example:
% y = L_psi(1+i,[0.75 1 0.1],{'ASY'})
%
% See also T_PSI
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Simon Emmanuel
% $Modified version : 27-Nov-2006$
% Modified by: Rami Ben-Zvi
% $Modified version : 16-Sep-2015$
% Modified by: Alon Nissan
% $Modified version : 20-March-2017$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------
str_psi = funpar{1};
switch str_psi
    %------------------------------------------------------------------------
case {'ADE'}
%     %------------------------------------------------------------------------    
    tchar = 1; % the exponential psi of the ADE model is not used directly 
    res  = 1./(1+tchar*u);   
    % -----------------------------------------------------------------------
% case {'FDE'}
%     % -----------------------------------------------------------------------
%     beta = param(1); 
%     res  = 1./(1+u.^beta);        
%     % -----------------------------------------------------------------------
case {'TPL'}
    % -----------------------------------------------------------------------
    beta = param(1); 
    t1   = param(2);	t1 = 10^(t1);
    t2   = param(3);	t2 = 10^(t2);
    mu   = t1 .* u;    
    tau2i= t1 ./ t2;
    x =  tau2i + mu;
    n = (  tau2i.^beta .* exp(tau2i) .* gammq(-beta, tau2i)  ).^(-1);

    if x <= 1
      res = n .* x.^beta .* exp(x) .* gammq(-beta,x);
    else 

% large x approximation using Laquerre qaudrature
      P = 8;
      [t, w] = lagzo(P);

      for p = 1:P
        fp = (1 + t(p)./ x)^( -1 - beta);  
        lagint(p) = w(p) .* fp;
      end					% p
      totlagint = sum(lagint);
      res = n ./ x .*  totlagint;
    end
    % -----------------------------------------------------------------------
% case {'ASY'}
%     % -----------------------------------------------------------------------    
%     beta  = param(1);  
%     a     = param(2);
%     b     = param(3);    
%     gamma = exp((log(-a/b))/(beta-1));
%     if beta>1
%         c = 10^round(log10(1/gamma));
%     else
%         c = 0;
%     end
%     res   = 1./(1 + a*u + b*u.^beta + c*u.^2);                     
%     % -----------------------------------------------------------------------
case {'ETA'}
    % -----------------------------------------------------------------------
    eta = param(1); 
    res =  qis(eta,u,{'ETA'});    
    % -----------------------------------------------------------------------
% case 'EXP'
%     % -----------------------------------------------------------------------
%     tchar = param(1);			    % tchar
%     Mu = mem(u, param, {'EXP'});	% M(u)
%     res = Mu / ( Mu + tchar*u );		% psi(u) from M(u) (general relation)
%   % -----------------------------------------------------------------------    
 otherwise
    res=eval(str_psi);
    % ---------------------------------------------------------------------
    % --    
% otherwise
%     fprintf(' Variable str_psi is: %s \n',str_mem);    
%     fprintf(' ERROR: valid options for variable "str_mem" are: \n')
%     fprintf('       "ADE", "FDE", "ASY", "TPL", "EXP" and "ETA". \n')
%     error('STOP')
    % -----------------------------------------------------------------------
end    
