function c_mat = calcola_coeff_eta(eta_vec)
% ------------------------------------------------------------
% CALCOLA_COEFF_ETA
% Computes the first 28 coefficients of the Taylor
% expansion for the ETA psi-function. The coefficients are 
% stored in the global variable c_mat
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------

global c_mat

for k=1:length(eta_vec)
    eta = eta_vec(k);
    c(1) = 2*eta;
    c(2) = -1/4*eta-4*eta^2;
    c(3) = .3703703704e-1*eta+.7500000000*eta^2+4.*eta^3;
    c(4) = -.5208333333e-2*eta-.1300154321*eta^2-1.*eta^3-2.666666667*eta^4;
    c(5) = .6666666667e-3*eta+.2073688272e-1*eta^2+.2015817901*eta^3+.8333333333*eta^4+1.333333333*eta^5;
    c(6) = -.7716049383e-4*eta-.3033809871e-2*eta^2-.3609664352e-1*eta^3-.1925154321*eta^4-.5000000000*eta^5-.5333333333*eta^6;
    c(7) = .8098477486e-5*eta+.4092335391e-3*eta^2+.5887377353e-2*eta^3+.3831500772e-1*eta^4+.1305298354*eta^5+.2333333333*eta^6+.1777777778*eta^7;
    c(8) = -.5079365079e-1*eta^8-.6800411523e-1*eta^6-.8888888889e-1*eta^7-.2861368313e-1*eta^5-.5132129630e-4*eta^2-.8872177331e-3*eta^3-.6870305296e-2*eta^4-.7750496032e-6*eta;
    c(9) = .6804276352e-7*eta+.1629050926e-1*eta^6+.5586836322e-2*eta^5+.1134415054e-2*eta^4+.1249302657e-3*eta^3+.6036800666e-5*eta^2+.1269841270e-1*eta^9+.2857142857e-1*eta^8+.2862654321e-1*eta^7;
    c(10) = -.5511463845e-8*eta-.7936507937e-2*eta^9-.7442772634e-2*eta^7-.1007985499e-1*eta^8-.1749375375e-3*eta^4-.9991797139e-3*eta^5-.3438136386e-2*eta^6-.6714758096e-6*eta^2-.1659172411e-4*eta^3-.2821869489e-2*eta^10;
    c(11) = .4140844361e-9*eta+.1664638669e-3*eta^5+.2545619569e-4*eta^4+.2094255202e-5*eta^3+.7110934839e-7*eta^2+.2827534049e-2*eta^8+.1687845660e-2*eta^7+.6607486963e-3*eta^6+.1940035273e-2*eta^10+.3044777582e-2*eta^9+.5643738977e-3*eta^11;
    c(12) = -.2899549582e-10*eta-.2527737948e-6*eta^3-.2613432601e-4*eta^5-.3523194422e-5*eta^4-.7207361644e-8*eta^2-.6855566369e-3*eta^8-.3464831143e-3*eta^7-.1178864944e-3*eta^6-.9167401529e-3*eta^9-.8042654648e-3*eta^10-.1026134360e-3*eta^12-.4232804233e-3*eta^11;
    c(13) = .1900478561e-11*eta+.2587326083e-3*eta^10+.2366215690e-3*eta^9+.1496064645e-3*eta^8+.6578487213e-4*eta^7+.3899408730e-5*eta^5+.1977762673e-4*eta^6+.7017681116e-9*eta^2+.2931252443e-7*eta^3+.4666328541e-6*eta^4+.1710223932e-4*eta^13+.8337341671e-4*eta^12+.1885873234e-3*eta^11;
    c(14) = -.3148830610e-5*eta^6-.5565197564e-6*eta^5-.5942724335e-7*eta^4-.6579967484e-10*eta^2-.3277637330e-8*eta^3-.1170484245e-12*eta-.3008207300e-4*eta^8-.1171557038e-4*eta^7-.7082806890e-4*eta^10-.5467536024e-4*eta^9-.6456237616e-4*eta^11-.1496445941e-4*eta^13-.3973202533e-4*eta^12-.2631113742e-5*eta^14;
    c(15) = .2466669133e-5*eta^14+.7596046691e-5*eta^13+.6797478873e-14*eta+.3758733918e-6*eta^15+.3543665603e-9*eta^3+.7635379197e-7*eta^5+.7304625129e-8*eta^4+.5949572133e-11*eta^2+.5658586475e-5*eta^8+.1976472030e-5*eta^7+.4790394731e-6*eta^6+.1727025046e-4*eta^10+.1159755966e-4*eta^9+.1868292540e-4*eta^11+.1442351944e-4*eta^12;
    c(16) = -.2295210700e-5*eta^9-.1006362059e-5*eta^8-.3181928044e-6*eta^7-.7000709588e-7*eta^6-.8691807824e-9*eta^4-.1011038656e-7*eta^5-.5191860625e-12*eta^2-.3712451763e-10*eta^3-.3758733918e-6*eta^15-.1328753043e-5*eta^14-.2914704561e-5*eta^13-.4399162056e-5*eta^12-.4793042076e-5*eta^11-.3851910107e-5*eta^10-.5011645223e-7*eta^16-.3733966666e-15*eta;
    c(17) = .1945645159e-16*eta+.1296208676e-8*eta^5+.1003630309e-9*eta^4+.3775139043e-11*eta^3+.4374532547e-13*eta^2+.1705423382e-6*eta^8+.4915914979e-7*eta^7+.9869166224e-8*eta^6+.7994469001e-6*eta^10+.4286018362e-6*eta^9+.1184342536e-5*eta^12+.1120936264e-5*eta^11+.9345019833e-6*eta^13+.5373792239e-6*eta^14+.2141659010e-6*eta^15+.5324873050e-7*eta^16+.6264556529e-8*eta^17;
    c(18) = -.2634015792e-6*eta^13-.1806835125e-6*eta^14-.2897239198e-6*eta^12-.9641485783e-18*eta-.3199709255e-7*eta^16-.9105222950e-7*eta^15-.7047626095e-8*eta^17-.7370066505e-9*eta^18-.1126827745e-10*eta^4-.3731540836e-12*eta^3-.3560021468e-14*eta^2-.2770299153e-7*eta^8-.7320769208e-8*eta^7-.1346642838e-8*eta^6-.1613183741e-9*eta^5-.1562447792e-6*eta^10-.7614550413e-7*eta^9-.2433178043e-6*eta^11;
    c(19) = .2799163324e-15*eta^2+.3589637768e-13*eta^3+.8188962783e-10*eta^19+.1054620906e-8*eta^7+.1783447001e-9*eta^6+.1953149913e-10*eta^5+.1232227733e-11*eta^4+.4333791851e-8*eta^8+.4554368558e-19*eta+.2900652946e-7*eta^10+.1295147282e-7*eta^9+.4963729994e-7*eta^11+.6562097026e-7*eta^12+.6725586933e-7*eta^13+.5320813819e-7*eta^14+.3203617218e-7*eta^15+.1426700182e-7*eta^16+.4454312378e-8*eta^17+.8751953975e-9*eta^18;
    c(20) = -.1023620348e-9*eta^19-.8619960824e-11*eta^20-.2055158812e-20*eta-.2119406730e-8*eta^9-.6553720517e-9*eta^8-.1473985446e-9*eta^7-.2297762227e-10*eta^6-.2304748462e-11*eta^5-.2127305705e-16*eta^2-.3364091355e-14*eta^3-.1314299834e-12*eta^4-.1415340171e-7*eta^14-.9837778543e-8*eta^15-.1586229250e-7*eta^13-.2078517984e-8*eta^17-.5804069542e-9*eta^18-.1394125230e-7*eta^12-.9603590899e-8*eta^11-.5148997879e-8*eta^10-.5242495430e-8*eta^16;
    c(21) = .2804648369e-8*eta^12+.3469655553e-8*eta^14+.3502578314e-8*eta^13+.3074117782e-15*eta^3+.8876617262e-22*eta+.1675866152e-8*eta^16+.2721437608e-8*eta^15+.7962130250e-9*eta^17+.2828817482e-9*eta^18+.9609973324e-10*eta^8+.2003569787e-10*eta^7+.7107289892e-10*eta^19+.2885572767e-11*eta^6+.2654752733e-12*eta^5+.1368987705e-13*eta^4+.1563387805e-17*eta^2+.8784647090e-9*eta^10+.3349982796e-9*eta^9+.8619960824e-12*eta^21+.1774365625e-8*eta^11+.1131369858e-10*eta^20;          
    c(22) = -.3676360080e-23*eta-.3611549396e-10*eta^19-.3538034844e-12*eta^6-.8208001856e-11*eta^20-.2988951992e-13*eta^5-.1394003469e-14*eta^4-.1111689088e-18*eta^2-.2741126691e-16*eta^3-.1185244613e-11*eta^21-.1369878733e-10*eta^8-.2654130646e-11*eta^7-.1446414216e-9*eta^10-.5131028956e-10*eta^9-.5381321245e-9*eta^12-.3147553493e-9*eta^11-.7312535357e-9*eta^13-.8209486499e-13*eta^22-.7948987775e-9*eta^14-.6923206428e-9*eta^15-.4813658332e-9*eta^16-.2645367044e-9*eta^17-.1127790694e-9*eta^18;
    c(23) = .1496231779e-10*eta^19+.4341339801e-11*eta^20+.8968317652e-12*eta^21+.1180113684e-12*eta^22+.7463169545e-14*eta^23+.1462446189e-24*eta+.1902412587e-11*eta^8+.1388936381e-15*eta^4+.3293153683e-14*eta^5+.4241470367e-13*eta^6+.7653372933e-20*eta^2+.2386486912e-17*eta^3+.7878268559e-10*eta^17+.1454250968e-9*eta^13+.9902940220e-10*eta^12+.5383843083e-10*eta^11+.2306169409e-10*eta^10+.7635961135e-11*eta^9+.3432479368e-12*eta^7+.3888711087e-10*eta^18+.1268903046e-9*eta^16+.1643083781e-9*eta^15+.1719308795e-9*eta^14;    
    c(24) = -.3537979108e-10*eta^14-.2770911165e-10*eta^13-.6489712648e-15*eta^24-.1119475432e-13*eta^23-.5596311011e-26*eta-.3115292658e-10*eta^16-.3676263067e-10*eta^15-.2149046389e-10*eta^17-.5346993422e-11*eta^19-.1199179072e-10*eta^18-.2029679765e-18*eta^3-.5104678702e-21*eta^2-.4340276389e-13*eta^7-.9297433495e-13*eta^22-.4977764531e-14*eta^6-.3554203411e-15*eta^5-.1355179348e-16*eta^4-.1106625425e-11*eta^9-.2578630623e-12*eta^8-.8910976489e-11*eta^11-.3570545826e-11*eta^10-.1866353581e-11*eta^20-.4929789517e-12*eta^21-.1755684816e-10*eta^12;    
    c(25) = .2063024091e-27*eta+.6968216761e-11*eta^14+.1686984458e-19*eta^3+.1014017601e-14*eta^24+.9168800355e-14*eta^23+.5408093873e-16*eta^25+.7816162341e-11*eta^15+.5451067303e-11*eta^17+.7200489691e-11*eta^16+.3380856675e-11*eta^18+.3416834267e-13*eta^8+.5373047850e-14*eta^7+.5725156753e-15*eta^6+.1705257525e-11*eta^19+.3760921774e-16*eta^5+.1295697307e-17*eta^4+.3300920824e-22*eta^2+.5303890068e-13*eta^22+.1564771330e-12*eta^9+.5380780550e-12*eta^10+.1431317513e-11*eta^11+.6903890041e-12*eta^20+.5081953232e-11*eta^13+.3009672777e-11*eta^12+.2196294349e-12*eta^21; 
    c(26) = -.7336083619e-29*eta-.1319876592e-11*eta^14-.1370736851e-20*eta^3-.8621340389e-15*eta^24-.5421064457e-14*eta^23-.8788152544e-16*eta^25-.1588937639e-11*eta^15-.4326475099e-17*eta^26-.1299957770e-11*eta^17-.1579647290e-11*eta^16-.8849583691e-12*eta^18-.4432077978e-14*eta^8-.6519539856e-15*eta^7-.6459372568e-16*eta^6-.4963271284e-12*eta^19-.3904868727e-17*eta^5-.1214676546e-18*eta^4-.2070921206e-23*eta^2-.2445768838e-13*eta^22-.2162389676e-13*eta^9-.7908498495e-13*eta^10-.2236596318e-12*eta^11-.2274485312e-12*eta^20-.9005405314e-12*eta^13-.5003734861e-12*eta^12-.8399879212e-13*eta^21;
    c(27) = .2519530827e-30*eta+.2413705150e-12*eta^14+.1089123266e-21*eta^3+.5276588466e-15*eta^24+.2584439876e-14*eta^23+.7745967787e-16*eta^25+.3103778982e-12*eta^15+.7300926729e-17*eta^26+.2939147490e-12*eta^17+.3310208330e-12*eta^16+.2175058137e-12*eta^18+.5634605949e-15*eta^8+.7761502918e-16*eta^7+.7155007267e-17*eta^6+.1339245457e-12*eta^19+.3980867781e-18*eta^5+.1117103068e-19*eta^4+.1261434673e-24*eta^2+.9660680531e-14*eta^22+.2924657459e-14*eta^9+.3328057768e-18*eta^27+.1135612884e-13*eta^10+.3407101646e-13*eta^11+.6827166620e-13*eta^20+.1546672795e-12*eta^13+.8088615534e-13*eta^12+.2855698722e-13*eta^21;
    c(28) = -.6659672887e-13*eta^16-.3876335832e-15*eta^9-.8367064380e-32*eta-.7465281804e-26*eta^2-.8464167870e-23*eta^3-.1008320436e-20*eta^4-.3987251017e-19*eta^5-.7787044961e-18*eta^6-.9073964359e-17*eta^7-.7028365674e-16*eta^8-.1595529792e-14*eta^10-.5068818935e-14*eta^11-.1274080750e-13*eta^12-.2581409805e-13*eta^13-.4275399591e-13*eta^14-.5849128535e-13*eta^15-.6341498153e-13*eta^17-.5062766868e-13*eta^18-.3388947380e-13*eta^19-.1897141902e-13*eta^20-.8831309641e-14*eta^21-.3385857848e-14*eta^22-.1053237467e-14*eta^23-.2597947594e-15*eta^24-.4901867494e-16*eta^25-.6662888493e-17*eta^26-.5824101094e-18*eta^27-.2465227976e-19*eta^28;
    c_mat(k,:)=c;
end
