function check_ilap(p,t,mod)

% ------------------------------------------------------------
% check_ilap:    script to plot the ADE/TPL/ETA psi function, to test 
%                                  how well the inverse Laplace script
%                                  (ilap.m)  recovers the psi in t-space.
%  psi(t) is plotted in red; the inverted psi(u) is plotted in blue, as an
%  overlay. If only blue appears on the plot, the match is perfect.
%  
%
% check_ilap(p,t,mod)
%
% t     := time vector
% p     := parameters of the psi function
% mod:= model type ('ADE', 'TPL' or 'ETA')
% Usage example:
% check_ilap([1.5 -1 4],linspace(0.1,500,100)','TPL')
%

% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Karen Willbrand
% $Original version : 10-March-2008$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------


%%% \psi(t)

if strcmp(mod,'ADE')
    psi=exp(-t);

elseif strcmp(mod,'TPL')
    bexp=p(1);
    t1=10^p(2);
    t2=10^p(3);

    C = t1*(t1/t2)^bexp*exp(t1/t2)*gammq(-bexp,t1/t2);
    psi = 1./C*exp(-t./t2)./((1+t./t1).^(1.+bexp));

elseif strcmp(mod,'ETA')
    eta=p(1);
    clencurt_coeff;
    calcola_coeff_eta(eta);

    psi=t_psi(t,eta,{'ETA'});
end

%semilogx(t,psi,'-r');
loglog(t,psi,'-r');

%%% Laplace inverted \tilde{\psi(u)}

psitfromu = ilap('L_psi' ,t, {p , {mod}});

hold on
%semilogx(t,psitfromu,'Color','b');
loglog(t,psitfromu,'Color','b');
ylabel('\psi(t)    ','Rotation',0,'FontSize',14);
xlabel('t','FontSize',14);
title(mod,'FontSize',18);

legend('\psi(t)','Laplace inverted \psi(u)','Location','Best')
hold off