function [x,w] = clencurt(N)
% CLENCURT  
% Computes nodes x (Chebyshev points) and weights w
% for Clenshaw-Curtis quadrature. Used to evaluate numerically
% the Laplace transform of the 'ETA' psi(t) function.
%
% [X,W] = CLENCURT(N)
%
% N := number of Chebyshev points
% x := Chebyshev points
% w := Clenshaw-Curtis quadrature weights
%
% Usage example:
% [x,w] = clencurt(64)
%
% See also QIS, CLENCURT_COEFF
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------

theta = pi*(0:N)'/N; x = cos(theta);
w = zeros(1,N+1); ii = 2:N; v = ones(N-1,1);
if mod(N,2)==0 
    w(1) = 1/(N^2-1); w(N+1) = w(1);
    for k=1:N/2-1, v = v - 2*cos(2*k*theta(ii))/(4*k^2-1); end
    v = v - cos(N*theta(ii))/(N^2-1);;
else
    w(1) = 1/N^2; w(N+1) = w(1);
    for k=1:(N-1)/2, v = v - 2*cos(2*k*theta(ii))/(4*k^2-1); end
end
w(ii) = 2*v/N;
