function clencurt_coeff
% CLENCURT_COEFF  
% Computes nodes x (Chebyshev points) and weights w
% for Clenshaw-Curtis quadrature. Used to evaluate numerically
% the Laplace transform of the 'ETA' psi(t) function.
% 
% This function calls upon the CLENCURT function, and evaluates
% Chebyshev points and Clenshaw-Curtis quadrature weights for
% a number of Chebyshev points equal to 2^i, i=1:10.
%
% The results are stored in the global variables x_mat, w_mat
%
% Usage example:
% clencurt_coeff
%
% See also QIS, CLENCURT
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------

global x_mat w_mat

for it=1:10
    N=2^it;
    [x , w] = clencurt(N);
    x_mat(1:N+1,N)=x;
    w_mat(N,1:N+1)=w;
end
