function [err , model] = diff_norm(varpar,tipo)
% DIFF_NORM
% Computes the norm of the difference between two vectors
% Given tha data         : t = data(:,1) , y = data(:,2).
% and the model function : function(t,param,funpar)
%
% [ERR,MODEL] = DIFF_NORM(VARPAR,TIPO)
%
% varpar := first  argument of the model function
% tipo   := second argument of the model function
% err    := norm of the difference between the vectors 
%           (or the log of the vectors)
% model  := value of the model function at the data points
%
% Example: 
% data = [
%      0.1000   -0.0064
%      0.2154    0.0124
%      0.4642    0.1593
%      1.0000    0.5104
%      2.1544    0.7817
%      4.6416    0.8576
%     10.0000    0.9281
%     100.0000    0.9846
% ];
% options = {'FDE','N','step','c_f_norm',1,1,'R'};
% s = [1 0.05 0.75];
% [err,model] = diff_norm(s,{data,'t_conc',options})
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Simon Emmanuel
% $Modified version : 27-Nov-2006$
% Modified by: Shira Rubin
% $Modified version : May-2010$
% Modified by: Rami Ben-Zvi
% $Modified version : 07-Sep-2015$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------
data     = tipo{1}; 
funzione = tipo{2};
options =  tipo{3};

com = strcat(funzione,'(data(:,1), varpar, options)');
 
if (varpar(1)>0 & varpar(2)>0)			% varpar(1) is v, varpar(2) is D
    model = eval(com);
    err = sum([norm(model(:,1) - data(:,2) )]);
 else
    model = NaN*ones(size(data(:,1)));
    err = NaN;
end
   
% fprintf(1,'difference = %6.4e \n',err);
