function [err , model] = diff_norm_lim_a(varpar,tipo)
% DIFF_NORM_LIM_A
% Computes the norm of the difference between two vectors
% Given tha data         : t = data(:,1) , y = data(:,2).
% and the model function : function(t,param,funpar)
% 
% [ERR,MODEL] = DIFF_NORM_LIM_A(VARPAR,TIPO)
% 
% varpar := first  argument of the model function
% tipo   := second argument of the model function
% err    := norm of the difference between the vectors 
%           (or the log of the vectors)
% model  := value of the model function at the data points
% 
% Example: 
% data = [
%     0.4642    0.1593
%     1.0000    0.5104
%     2.1544    0.7817
%     4.6416    0.8576
%    10.0000    0.9281
%    21.5443    0.9692
%    46.4159    0.9672
% ];
% options = {'FDE','N','step','c_f_norm',1,1,'R'};
% VD = [1 0.05];
% s = [0.75];
% [err,model] = diff_norm_lim_a(s,{VD, data,'t_conc',options})
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Simon Emmanuel
% $Modified version : 27-Nov-2006$
% Modified by: Shira Rubin
% $Modified version : May-2010$
% Modified by: Rami Ben-Zvi
% $Modified version : 07-Sep-2015$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------
L1 = length(varpar);	% number of variable parameters
L2 = length(tipo{1});	% number of "forced" parameters
L = L1 + L2;
if L2>0
  varpar_new(1:L2) = tipo{1};	% "forced" parameters
  varpar_new(L2+1:L) = varpar;	% variable parameters
else
  varpar_new = varpar; 
end
data     = tipo{2}; 
funzione = tipo{3};
options = tipo{4};

com = strcat(funzione,'(data(:,1), varpar_new, options)');
 
if (varpar_new(1)>0 & varpar_new(2)>0)
    model = eval(com);
    err = sum([norm(model(:,1) - data(:,2) )]);
 else
    model = NaN*ones(size(data(:,1)));
    err = NaN;
end
   
fprintf(1,'difference = %6.4e \n',err);
