function [err , model1, model2] = diff_norm_multi(varpar,....
    tipo_1, tipo_2)

% DIFF_NORM_MULTI
% Computes the norm of the difference between two sets of vectors.
% Given tha data         : t1 = data1(:,1) , y1 = data1(:,2)
%                                               t2 = data2(:,1) , y2 = data2(:,2).
% and the model function : function(t,param,funpar)
%
% [ERR,MODEL1, MODEL2] = DIFF_NORM_LIM(VARPAR,TIPO1, TIPO2)
%
% varpar := first  argument of the model function
% tipo1   := second argument of the model function
% tipo2   := second argument of the model function
% err    := norm of the difference between the vectors 
%           (or the log of the vectors)
% model1  := value of the model function at the data points of dataset 1
% model2  := value of the model function at the data points of dataset 2
%
% See DIFF_NORM and DIFF_NORM _LIM

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Simon Emmanuel
% $Modified version : 27-Nov-2006$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------

% First data set
data_1     = tipo_1{1};
funzione_1 = tipo_1{2};
options_1 = tipo_1{3};

% Second data set
data_2    = tipo_2{1}; 
funzione_2 = tipo_2{2};
options_2 = tipo_2{3};

com_1 = strcat(funzione_1,'(data_1(:,1), [varpar], options_1)');
com_2 = strcat(funzione_2,'(data_2(:,1), [varpar], options_2)');
 
if (varpar(1)>0 & varpar(2)>0)
    model1 = eval(com_1);
    model2 = eval(com_2);
    
    err = sum([...
     norm(model1(:,1) - data_1(:,2) ) ...
     norm(model2(:,1) - data_2(:,2) )...
            ]);
else
    model1 = NaN*ones(size(data_1(:,1)));
    model2 = NaN*ones(size(data_2(:,1)));
    err = NaN;
end
   
fprintf(1,'difference = %6.4e \n',err);