function res=gammq(a,z)
% ------------------------------------------------------------
% GAMMQ
%  Calculates the incomplete Gamma function for non-integer values
%  of Z
% 
% RES = GAMMQ(A,Z)
%
% A   := parameter           of the incomplete Gamma function
% Z   := point of evaluation of the incomplete Gamma function
% RES := value               of the incomplete Gamma function
% 
% Usage example:
% y = gammq(2,2.3)
%
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v3.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Simon Emmanuel
% $Modified version : 27-Nov-2006$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------
if a>0
    res = (1-gammainc07(z,a)).*gamma(a);
elseif  0 >= a > -1
    res = -exp(-z).*z.^a/a + 1/a*gammq(a+1,z);
elseif -1 >= a > -2
    res = -exp(-z).*z.^a/a + 1/a*( ...
        -exp(-z).*z.^(a+1)/(a+1) + 1/(a+1)*gammq(a+2,z) );
else
    error('ERROR: ')
end
if a == -1 | a == -2 | a == 0
      fprintf('%s\n','Error in gammaq. Illegal use of integer for beta parameter') ;               
end
