function gen_output(vDp_old, vDp, err_old, err, mod_type, output)

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Simon Emmanuel
% $Modified version : 27-Nov-2006$
% Modified by: Rami Ben-Zvi
% $Modified version : 16-Sep-2015$
% Modified by: Alon Nissan
% $Modified version : 20-March-2017$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

delete output.txt;
LL='L';
TT='T';
LT = 'log10(T)';
TFDE = 'T^(1+Beta)';

LE = length(vDp);
fid = fopen(output,'a');

if LE == 2
    fprintf(fid,'v(initial) : %6.4e [%s/%s]   \n', vDp_old(1), LL, TT);
    fprintf(fid,'D(initial) : %6.4e  [%s^2/%s]         \n',vDp_old(2) , LL, TT);
    fprintf(fid,'v(final) : %6.4e [%s/%s]   \n', vDp(1), LL, TT);
    fprintf(fid,'D(final) : %6.4e  [%s^2/%s]         \n',vDp(2) , LL, TT);
end

if (LE == 3) && (strcmp(mod_type,'ETA'))
    fprintf(fid,'v(initial) : %6.4e [%s/%s]   \n', vDp_old(1), LL, TT);
    fprintf(fid,'D(initial) : %6.4e  [%s^2/%s]         \n',vDp_old(2) , LL, TT);
    fprintf(fid,'Eta(initial) : %6.4e         \n',vDp_old(3) );
    fprintf(fid,'v(final) : %6.4e [%s/%s]   \n', vDp(1), LL, TT);
    fprintf(fid,'D(final) : %6.4e  [%s^2/%s]         \n',vDp(2) , LL, TT);
    fprintf(fid,'Eta(final) : %6.4e         \n',vDp(3) );
end


% if (LE == 3) && (strcmp(mod_type,'FDE'))
%     fprintf(fid,'v(initial) : %6.4e [%s/%s]   \n', vDp_old(1), LL, TFDE);
%     fprintf(fid,'D(initial) : %6.4e  [%s^2/%s]         \n',vDp_old(2) , LL, TFDE);
%     fprintf(fid,'Beta(initial) : %6.4e         \n',vDp_old(3) );
%     fprintf(fid,'v(final) : %6.4e [%s/%s]   \n', vDp(1), LL, TFDE);
%     fprintf(fid,'D(final) : %6.4e  [%s^2/%s]         \n',vDp(2) , LL, TFDE);
%     fprintf(fid,'Beta(final) : %6.4e         \n',vDp(3) );
% end


if (LE == 5) && (strcmp(mod_type,'TPL'))
    t2   = 10.^(vDp_old(5));
    t1   = 10.^(vDp_old(4));
    beta = (vDp_old(3));
    
    tmean_old = (((t2./t1).^beta) .* (-t1 + (exp(t1./t2)) .* ((t1./t2).^beta) .* (t1 + beta.*t2).*gammq(1 - beta, t1./t2)))...
        ./(exp(t1./t2).*(beta*gammq(-beta, t1./t2)));
  
    
   
    t2   = 10.^(vDp(5));
    t1   = 10.^(vDp(4));
    beta = (vDp(3));
    
    tmean = (((t2./t1).^beta) .* (-t1 + (exp(t1./t2)) .* ((t1./t2).^beta) .* (t1 + beta.*t2).*gammq(1 - beta, t1./t2)))...
        ./(exp(t1./t2).*(beta*gammq(-beta, t1./t2)));
       
    fprintf(fid,'v(initial) : %6.4e [%s/%s]   \n', vDp_old(1), LL, TT);
    fprintf(fid,'D(initial) : %6.4e  [%s^2/%s]         \n',vDp_old(2) , LL, TT);
    fprintf(fid,'Beta(initial) : %6.4e         \n',vDp_old(3) );
    fprintf(fid,'log10(t1)(initial): %6.4e  [%s]         \n',vDp_old(4), LT );
    fprintf(fid,'log10(t2)(initial): %6.4e  [%s]         \n',vDp_old(5), LT );
    fprintf(fid,'tmean(initial): %6.4e  [%s]         \n',tmean_old, TT );
    fprintf(fid,'v(final) : %6.4e [%s/%s]   \n', vDp(1), LL, TT);
    fprintf(fid,'D(final) : %6.4e  [%s^2/%s]         \n',vDp(2) , LL, TT);
    fprintf(fid,'Beta(final) : %6.4e         \n',vDp(3) );
    fprintf(fid,'log10(t1)(final): %6.4e  [%s]         \n',vDp(4), LT );
    fprintf(fid,'log10(t2)(final): %6.4e  [%s]         \n',vDp(5), LT );
    fprintf(fid,'tmean(final): %6.4e  [%s]         \n',tmean, TT );
end

% if (LE == 5) && (strcmp(mod_type,'ASY'))
%     fprintf(fid,'v(initial) : %6.4e [%s/%s]   \n', vDp_old(1), LL, TT);
%     fprintf(fid,'D(initial) : %6.4e  [%s^2/%s]         \n',vDp_old(2) , LL, TT);
%     fprintf(fid,'Beta(initial) : %6.4e         \n',vDp_old(3) );
%     fprintf(fid,'a(initial): %6.4e  [%s]         \n',vDp_old(4), LT );
%     fprintf(fid,'b(initial): %6.4e  [%s]         \n',vDp_old(5), LT );
%     fprintf(fid,'v(final) : %6.4e [%s/%s]   \n', vDp(1), LL, TT);
%     fprintf(fid,'D(final) : %6.4e  [%s^2/%s]         \n',vDp(2) , LL, TT);
%     fprintf(fid,'Beta(final) : %6.4e         \n',vDp(3) );
%     fprintf(fid,'a(final): %6.4e  [%s]         \n',vDp(4), LT );
%     fprintf(fid,'b(final): %6.4e  [%s]         \n',vDp(5), LT );
% end

% if  strcmp(mod_type,'EXP')
%     Np = (LE - 3) / 2 ;		% # of Prony terms
%     fprintf(fid,'Np = %5i\n', Np);
%     
%     fprintf(fid,'\n Initial EXP model parameters: \n');
%     fprintf(fid,'v : %6.4e [%s/%s]   \n', vDp_old(1), LL, TT);
%     fprintf(fid,'D : %6.4e  [%s^2/%s]         \n',vDp_old(2) , LL, TT);
%     fprintf(fid,'t1 = %6.4e [%s] \n', vDp_old(3), TT);
%     fprintf(fid,'%14s %14s %14s \n', 'n', 'An', 'Bn [1/T]' );
%     for n=1:Np
%         k = 2*n+2;
%         An=vDp_old(k  );			% An
%         Bn=vDp_old(k+1);			% Bn
%         fprintf(fid,'%14i %14.7e %14.7e \n', n, An, Bn );
%     end	% n
%     
%     fprintf(fid,'\n Final   EXP model parameters: \n');
%     fprintf(fid,'v : %6.4e [%s/%s]   \n', vDp    (1), LL, TT);
%     fprintf(fid,'D : %6.4e  [%s^2/%s]         \n',vDp    (2) , LL, TT);
%     fprintf(fid,'t1 = %6.4e [%s] \n', vDp    (3), TT);
%     fprintf(fid,'%14s %14s %14s \n', 'n', 'An', 'Bn [1/T]' );
%     for n=1:Np
%         k = 2*n+2;
%         An=vDp(k  )    ;			% An
%         Bn=vDp(k+1)    ;			% Bn
%         fprintf(fid,'%14i %14.7e %14.7e \n', n, An, Bn );
%     end	% n
% end

fprintf(fid,'error(initial) : %6.4e          \n', err_old );
fprintf(fid,'error(final) : %6.4e          \n', err );
fclose(fid);
