function res = mem(u,param,options)
% ------------------------------------------------------------
% MEM
% Laplace transformed memory function $\tilde{M}(u)$
% for the different models ADE, TPL, ASY, FDE, ETA. 
% 
% RES = MEM(U,PARAM,OPTIONS)
%
% u     := Laplace variable
% param := parameters of the psi function
% options:= cell array
% res   := values of the function $\tilde(M)(u)$
% 
% Usage example:
% y = MEM(1+i,[1 0.05 0.75],{'TPL', 'N', 'step', 'c_f_norm', 1, 1, 'R'})
%
% See also L_PSI, QIS
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Simon Emmanuel
% $Modified version : 27-Nov-2006$
% Modified by: Shira Rubin
% $Modified version : May-2010$
% Modified by: Rami Ben-Zvi
% $Modified version : 07-Sep-2015$
% Modified by: Alon Nissan
% $Modified version : 20-March-2017$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------
if length(options)>=8  % Sorption/desorption model
    sorption=1;
    lambda=options{8}(1);
    tau=options{8}(2);
    W=options{8}(3);
    phi=W*L_psi(u,options{10},options(9))+(1-W)./u/tau;
    nu=u+lambda*(1-phi);
    u1=nu; % u1 is the input Laplace variable for L_psi
else
    u1=u;
    sorption=0;
end

str_mem = options{1};

switch str_mem
    % -----------------------------------------------------------------------
case 'ADE'
    % ----------------------------------------------------------------------- 
    if sorption==1
        tchar = 1;
        psi  = L_psi(u1,[],{'ADE'});
        res  = tchar*psi/(1-psi)*u;
    else
        res=1;
    end
%     % -----------------------------------------------------------------------
% case 'FDE'
%     % -----------------------------------------------------------------------
%     beta  = param(1);      
%     if (beta>0 && beta<1)
%         psi  = L_psi(u1,beta,{'FDE'}); 
%         tchar = 1;
%         res  = tchar*psi/(1-psi)*u;
%     else
%         res  = NaN;
%     end        
    % -----------------------------------------------------------------------
case 'TPL'
    % -----------------------------------------------------------------------
    beta    = param(1); 
    t1      = param(2); t1 = 10^t1;
    t2      = param(3); t2 = 10^t2;
    
    
    tmean = (((t2./t1).^beta) .* (-t1 + (exp(t1./t2)) .* ((t1./t2).^beta) .* (t1 + beta.*t2).*gammq(1 - beta, t1./t2)))...
        ./(exp(t1./t2).*(beta*gammq(-beta, t1./t2)));
    
    
    if (beta<0 || t1<0 || t2<0); res = NaN; end

    if t2 > t1
      tchar = t1;  
%       tchar = tmean;
      psi = L_psi(u1,param,{'TPL'}); 
      res = tchar*psi/(1-psi)*u;
    else
        res = NaN;
    end 
%    % -----------------------------------------------------------------------
% case 'ASY'
%     % -----------------------------------------------------------------------
%     beta  = param(1);  
%     if (beta>0 && beta<2)
%       a     = param(2);
%       b     = param(3);    
%       psi   = L_psi(u1,[beta a b],{'ASY'}); 
%       tchar  = a;    
%       res = tchar*psi/(1-psi)*u;
%     else
%       res = NaN;
%     end    
    % -----------------------------------------------------------------------
case 'ETA'
    % -----------------------------------------------------------------------
    eta=param(1);
    load N
    load median_N
    tchar = interp1(N,median_N,eta); % median time
    psi = qis(eta,u1,{'ETA'});
    res = tchar*psi/(1-psi)*u;    
%     % -----------------------------------------------------------------------
% case 'EXP'
%     % -----------------------------------------------------------------------
%     p         = param;
%     Np = (length(p) - 1) / 2 ;		% # of Prony terms
%     res = 0;
%     for n = 1:Np
%       An=p(2*n  );			% An
%       Bn=p(2*n+1);			% Bn
% % add the n-th term to M(u)
%       if( Bn == 0)
%         res = res + An;	% if Bn=0, i.e., An * delta(t), the u domain term is An
%       else
%         res = res + An / (u + Bn );	% otherwise, it is An/( U + Bn)
%       end
%     end     % n
%     % -----------------------------------------------------------------------
    otherwise
         tchar =param(1); % median time
         psi  = L_psi(u1,[],{str_mem});
         res  = tchar*psi/(1-psi)*u;

%     fprintf(' Variable str_mem is: %s \n',str_mem);
%     fprintf(' ERROR: valid options for variable "str_mem" are: \n')
%     fprintf('       "ADE", "FDE", "ASY", "TPL", "EXP" and "ETA". \n')
%     error('STOP')
%     % -----------------------------------------------------------------------
end    
