function somma = qis(param,csi,funpar)
% ------------------------------------------------------------
% QIS
% Laplace transformed memory function $\tilde{M}(u)$
% for the different ETA $\psi(t)$ model.
% 
% SOMMA = QIS(PARAM,U,FUNPAR)
%
% u     := Laplace variable
% param := parameters of the psi function
% funpar:= string specifying the model
% res   := values of the function $\psi(t)$
% 
% Usage example:
% y = qis([0.75 1 0.1],1+i,{'ASY'})
%
% See also T_PSI
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v3.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------

global x_mat w_mat c_mat

str_psi = funpar{1};

N = 2^6 ; 
y = x_mat(1:N+1,N) ; 
w = w_mat(N,1:N+1) ;

a = 0 ; b = 1; t = ((b+a)/2-a)*y + ((b+a)/2) ; 

f = 0;
res = zeros(size(t));
for j=1:length(t);
    f=t_psi(t(j),param,{str_psi});
    res(j) = f*exp(-csi*t(j)) ;
end
somma = w*res*(b-a)/2;

err = 1e3; err_max = 1e-6; k=0;
res = zeros(size(t));
dk  = 0.25 ;
while err > err_max
    k = k + dk; 
    a = 10^(k-dk); b = 10^k; t = ((b+a)/2-a)*y + ((b+a)/2) ;
    f = 0;
    for j=1:length(t);
        f = t_psi(t(j),param,{str_psi});
        res(j) = f*exp(-csi*t(j)) ;
    end
    somma_parz = w*res*(b-a)/2;         
    somma = somma + somma_parz;
    err   = abs(somma_parz/somma);
    %fprintf('k = %i ; somma = %10.8e ; err = %10.8e \n', k,somma ,err)
end
