function [t1, t2] = t1_calc(t2,V,D,beta)
% Calculate the TPL characteristic time, t1.

Tau = 1/t2;   % Assumption for t1/t2

if (beta > 1.4 && Tau < 1e-5)
    t1 = (D*(beta-1))/(V^2);
else
    t1  = ((beta * D *  ((1/Tau).^(-1-beta))) * igamma(-beta, Tau))...
        / ((V^2) * (-Tau + (Tau^beta) * (beta + Tau)*igamma(1-beta, Tau)));
    t2 = t1 / Tau;
end

end




