function res = t_psi(t,param,funpar)
% ------------------------------------------------------------
% T_PSI
% Calculates the inverse Laplace transform of the
% ${\psi}(t)$ function
%
% RES = T_PSI(T,PARAM,FUNPAR)
%
% t     := time vector
% param := parameters of the psi function
% funpar:= string specifying the model
% res   := Laplace transformed psi function $(\tilde{\psi}(u))$
%
% Usage example:
% t = transpose(logspace(-4,4,100));
% y = t_psi(t,[0.075],{'ETA'});
% loglog(t,y)
%
% See also L_PSI
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v4.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Rami Ben-Zvi
% $Modified version : 01-Sep-2015$
% Modified by: Alon Nissan
% $Modified version : 20-March-2017$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------
global x_mat w_mat c_mat z_mat

str_psi = funpar{1};

switch str_psi
    % -----------------------------------------------------------------------
    case {'ADE'}
        % -----------------------------------------------------------------------

        res = ilap('L_psi' ,t, {[],{'ADE'}});

        % -----------------------------------------------------------------------
    case {'TPL'}
        % -----------------------------------------------------------------------
        bexp = param(:,1);
        t1   = param(:,2); t1 = 10^(t1);
        t2   = param(:,3); t2 = 10^(t2);

        C = t1*(t1/t2)^bexp*exp(t1/t2)*gammq(-bexp,t1/t2);
        res = 1./C*exp(-t./t2)./((1+t./t1).^(1.+bexp));

%         % -----------------------------------------------------------------------
%     case {'ASY'}
%         % -----------------------------------------------------------------------
% 
%         res = ilap('L_psi' ,t, {param,{'ASY'}});

%         % -----------------------------------------------------------------------
%     case {'FDE'}
%         % -----------------------------------------------------------------------
% 
%         res = ilap('L_psi' ,t, {param,{'FDE'}});

        % -----------------------------------------------------------------------
    case {'ETA'}
        % -----------------------------------------------------------------------

        eta = param(1) ;
        t0 = 1;
        if  eta<=0.05           ; t0 = 5   ; end
        if (eta>0.05 & eta<=0.5); t0 = 3   ; end
        if (eta>0.5  & eta<=1)  ; t0 = 2   ; end
        if (eta>1    & eta<=2)  ; t0 = 1.5 ; end
        if (eta>2    & eta<=3)  ; t0 = 1   ; end
        % =========================================================================
        c   = c_mat(1,:);
        % =========================================================================
        gamma = 0.5772156649;
        e = exp(1);
        res = zeros(size(t));
        for j=1:length(t);
            tj=t(j);
            if tj<t0
                tj_vec = tj.^(0:28-1); f = sum(c.*tj_vec);
            elseif tj>=t0
                f = (eta*(pi^2 + 6*(gamma + log(tj))^2))/ ...
                    (6*e^((eta*(pi^2*(gamma + log(tj)) + 2*(gamma + log(tj))^3 + 4*1.20205690315959))/6)*tj);
            end
            res(j) = f;
        end
        
%         % -----------------------------------------------------------------------
%     case 'EXP'
%         % -----------------------------------------------------------------------
% 
%         res = ilap('L_psi' ,t, {param,{'EXP'}});
%     
%         % -----------------------------------------------------------------------

    otherwise
        
        res = ilap('L_psi' ,t, {param,{funpar{1}}});

%             fprintf(' Variable str_psi is: %s \n',str_mem);
%             fprintf(' ERROR: valid options for variable "str_mem" are: \n')
%             fprintf('       "ADE", "TPL",  and "ETA". \n')
%             error('STOP')

end
