function y = t_resid_2d(t,param,options)
% ------------------------------------------------------------
% T_RESID_2D
% 
% t      := time vector  
% varpar := vector containing the velocity, 
%           the dispersion and the psi parameters
% options:= cell array containing information on the model,
%           the outlet boundary condition, the inlet input,
%           the kind of concentration, and the coordinates of
%           the section at which the concentration is computed.
% y      := vector of concentrations
% 
% Y = T_RESID_2D(t);
%           
% (see the User's Guide for a detailed description)
%
% Example
% y=t_resid_2d(transpose(linspace(7,20,3)), ...
%              [0.1 5e-3 5e-4 [1.75 log(1) log(100)]], ...
%              {'TPL',linspace(0.1,20,5),linspace(-1,1,4),1});
%
% See also L_resid_2d
% ------------------------------------------------------------

% This file is part of the CTRW toolbox v3.0
% For the usage of this file see Legal_notice.m
% Author   : Andrea Cortis
% $Original version : 26-Jun-2004$
% Modified by: Simon Emmanuel
% $Modified version : 27-Nov-2006$
% e-mail   : brian.berkowitz@weizmann.ac.il
%           (see http://weizmann.ac.il/ESER/people/Brian/CTRW)

% ------------------------------------------------------------

str_mem   = options{1};
x1_vec    = options{2};
x2_vec    = options{3};
conc      = options{4};
n1        = length(x1_vec);
n2        = length(x2_vec);

switch str_mem
case 'ETA'
    eta = param(4:length(param));
    clencurt_coeff;
    calcola_coeff_eta(eta);    
end

h = waitbar(0,'t\_resid\_2d: Please wait...');
[x1_mat,x2_mat]=meshgrid(x1_vec,x2_vec);
x1_col = x1_mat(:)     ; x2_col = x2_mat(:);
k=0;
y = zeros(n2,n1,length(t));
for j=1:n1
    for i=1:n2
        k=k+1;
        waitbar(k/n1/n2,h)
        x1=x1_col(k); 
        x2=x2_col(k);
        z = ilap('L_resid_2D' ,t, {param,{options{1},x1,x2}});
        y(i,j,:) = z;
    end
end
close(h)

y=y*conc;

% save data.mat t x1_mat x2_mat y
%
% load data.mat -MAT; 
% 
% fig=figure;
% set(fig,'DoubleBuffer','on');
% set(gca,'xlim',[min(x1_col) max(x1_col)],...
%         'ylim',[min(x2_col) max(x2_col)],...
%         'NextPlot','replace','Visible','off')
% 
% for k=1:length(t)
%    contour(x1_mat,x2_mat,y(:,:,k)) , colorbar , grid on   
%    pause
% end
