function result = CoSeM_denoising_run(spektar_radni,options)


%% Control parameters

 N_recoveries=options.rendition_number;
 fraction=options.fraction;
 lambda = options.lambda; 
 N1_new=size(spektar_radni,2);
 N2=size(spektar_radni,1);
 M=N_recoveries; 
 M2=floor(options.sa_tresh * N_recoveries);
offset = options.offset;
 
 %% Preparation

fid_fake=(ifftshift(ifft(ifft(spektar_radni,[],1),[],2),1)); % Go to the temporal or pseudotemporal dimension

if options.ordering ~= 1
    fid_fake=permute( fid_fake ,[options.ordering 1]);  %Put the noisy dimension to be the first one if needed

end
 if options.type_of_data == 2 %debug
    fid_fake=fftshift(fid_fake,1);
 end
 stored_spectra=zeros(N2,N1_new,N_recoveries); 25% optimal
 
stored_spectra_all=zeros([N2,N1_new,N_recoveries]);
 
 
%% Generate renditions
for jj=1:N_recoveries 

    masks=generate_1D_mask(N1_new,fraction,1);
    masks=repmat(masks',1,N2);
    fid_fake_masked=fid_fake.*masks;
    spectra_fake=zeros(size(fid_fake_masked));
    spectra_fake = bart(['pics -d5 -S -R T:7:0:',num2str(lambda)],fid_fake_masked,masks);
    fud_fake_2=flip(fft(fftshift(fft(spectra_fake,[],1),1),[],1),1); %correct for bart's built-in flipping
    spectra_fake=permute((ifftshift(ifftshift(fud_fake_2,2),1)),[options.ordering 1]);
    stored_spectra_all(:,:,jj) = spectra_fake; 

end


%%
if options.type_of_data == 1 %spectrum

spektra_fake_all_5_ent = stored_spectra_all./norm(stored_spectra_all(:)); %normalize the results
clear stored_spectra_all;
S =- sum(abs(real(spektra_fake_all_5_ent)).*log(abs(real(spektra_fake_all_5_ent))),[1,2]); % entropy
S_red=squeeze(S);
for ii=1:size(spektra_fake_all_5_ent,3)
    norm_crit(ii)= norm(vec(spektra_fake_all_5_ent(:,:,ii)),1)./norm(vec(spektra_fake_all_5_ent(:,:,ii)),2);
end

[~,I_S] = mink(S_red,M);
[~,I_crit1] = mink(norm_crit,M);

entropy_sort = spektra_fake_all_5_ent(:,:,I_S);
norm_sort = spektra_fake_all_5_ent(:,:,I_crit1);

result.selective_avg = sum(norm_sort(:,:,1:M2),3)/M2;
result.blind_avg = sum(norm_sort(:,:,1:M),3)/M;
result.selective_avg_ent = sum(entropy_sort(:,:,1+offset:M2+offset),3)/M2;

if options.saveall == 1
   result.allrenditions =  norm_sort;
end

result.selective_avg = (result.selective_avg./norm(abs(result.selective_avg(:)))*norm(spektar_radni(:)));
result.selective_avg = flip(flip(result.selective_avg,1),2);

result.selective_avg_ent = (result.selective_avg_ent./norm(abs(result.selective_avg_ent(:)))*norm(spektar_radni(:)));
result.selective_avg_ent = flip(flip(result.selective_avg_ent,1),2);

result.blind_avg = (result.blind_avg./norm(abs(result.blind_avg(:)))*norm(spektar_radni(:)));
result.blind_avg = flip(flip(result.blind_avg,1),2);

result.selective_avg=circshift(result.selective_avg,1,1);
result.blind_avg =circshift(result.blind_avg ,1,1);
result.selective_avg_ent=circshift(result.selective_avg_ent,1,1);

elseif options.type_of_data ==2 %image processing
 
spektra_fake_all_5_ent = stored_spectra_all./norm(stored_spectra_all(:));
clear stored_spectra_all;


for ii=1:size(spektra_fake_all_5_ent,3)
    [Gmag,~] = imgradient(abs(spektra_fake_all_5_ent(:,:,ii)));
    norm_crit(ii)= norm(vec(Gmag),1)./norm(vec(Gmag),2);
    S2(ii) =- sum(abs((Gmag)).*log(abs((Gmag))),[1,2]);
end

[~,I_S] = mink(S2,M);
[~,I_crit1] = mink(norm_crit,M);

entropy_sort = spektra_fake_all_5_ent(:,:,I_S);
norm_sort = spektra_fake_all_5_ent(:,:,I_crit1);

result.selective_avg = sum(norm_sort(:,:,1+offset:M2+offset),3)/M2;
result.selective_avg_ent = sum(entropy_sort(:,:,1+offset:M2+offset),3)/M2;
result.blind_avg = sum(norm_sort(:,:,1:M),3)/M;
result.selective_avg = flip(flip(result.selective_avg,1),2);
result.selective_avg_ent= flip(flip(result.selective_avg_ent,1),2);
result.blind_avg  = flip(flip(result.blind_avg ,1),2);

result.selective_avg=circshift(result.selective_avg,1,1);
result.blind_avg =circshift(result.blind_avg ,1,1);
result.selective_avg_ent=circshift(result.selective_avg_ent,1,1); %disrepancy between phase convention used in MRI and used in bart



if options.saveall == 1
   result.allrenditions =  norm_sort;
end

end

result.selective_avg=(ifftshift(ifft(ifft(result.selective_avg,[],1),[],2),1)); result.selective_avg=fft2(fftshift(result.selective_avg));
result.selective_avg_ent=(ifftshift(ifft(ifft(result.selective_avg_ent,[],1),[],2),1)); result.selective_avg_ent_avg=fft2(fftshift(result.selective_avg_ent));
result.blind_avg=(ifftshift(ifft(ifft(result.blind_avg,[],1),[],2),1)); result.blind_avg=fft2(fftshift(result.blind_avg));

end