%CoSeM denosing 
currentpath = pwd;
%%For BART:
cd /home/davidkop36/bart/bart-0.5/bin/
run("/home/davidkop36/bart/bart-0.5/bin/startup.m");
fprintf('Passed the startup line');
%You need to run setup m-file from bart's directory prior to running CoSeM 
cd (currentpath);
%% Data to be denoised - Number of transients is the size of the third dimension in the matrix
load('EPIdata.mat')
Data = EPIdata;
NumberTransients = size(Data,3);

%% Options

options.rendition_number = 2000; % How many renditions are to be done (max number depends on the maximal memory you can allocate)
options.fraction = 0.1; % How many points are randomly taken out in each renditions along the indirect dimension
options.ordering = 2; % Which dimension is the dimension with t1-noise, default is 2 - this means the 2nd dimension comes first
options.lambda = .05; % Strength of regularization in the reconstruction phase | Usually ranges between 0.05 and 10
options.type_of_data = 2; % 1 for a spectrum, 2 for image
options.sa_tresh = 0.05; % How many renditions to be used for selective averaging | kept low for a low rendition number
options.offset = 0; % Start-point for selective averaging 
options.saveall = 0; % Saves all renditions if set to 1 (debug-only)

%% Denoising Section
for i=1:NumberTransients
spektar_radni=squeeze(Data(:,:,i));

results = CoSeM_denoising_run(spektar_radni,options);

SelectiveAveraging(:,:,i) = results.selective_avg;
BlindAveraging(:,:,i) = results.blind_avg;
SelectiveAveragingEnt(:,:,i) = results.selective_avg_ent;
%% Rescaling of the Image
OriginalData = Data(:,:,i);
OriginalDataNorm = norm(OriginalData(:));

SelectiveAveraging(:,:,i)=SelectiveAveraging(:,:,i).*OriginalDataNorm/norm(SelectiveAveraging(:,:,i));
BlindAveraging(:,:,i)=BlindAveraging(:,:,i).*OriginalDataNorm/norm(BlindAveraging(:,:,i));
BlindAveraging(:,:,i)=BlindAveraging(:,:,i).*OriginalDataNorm/norm(BlindAveraging(:,:,i));

FinalResults.SelectiveAveraging(:,:,i) = SelectiveAveraging(:,:,i);
FinalResults.BlindAveraging(:,:,i) = BlindAveraging(:,:,i);
FinalResults.SelectiveAveragingEnt(:,:,i) = SelectiveAveragingEnt(:,:,i);
end
cd (currentpath);
save('DenoisedData_mouse_EPI_demo','options','FinalResults')
