function [snr, SNR_t] = SNR_calc(Spect,ppm_axis,expt,signal_bound,noise_bound)

ppm_axis = sort(ppm_axis,'descend');


% Upper spectral boundary
ub = find(ppm_axis < max(signal_bound));
ub1 = ub(1);

% Lower spectral boundary
lb = find(ppm_axis > min(signal_bound));
lb1 = lb(end);

spect = Spect(ub1:lb1);  %  the spec region

% Upper noise boundary
ubb = find(ppm_axis < max(noise_bound));
ub2 = ubb(1);

% Lower noise boundary
lbb = find(ppm_axis > min(noise_bound));
lb2 = lbb(end);

noise_spec = Spect(ub2:lb2);  %  the noise region


% Defining the signal maximum of the spectrum
signal_max = max(abs(spect));

% Calculating the mean and standard deviation of the noise
noise_std = std(noise_spec, 1);
noise_avg = mean(noise_spec);

snr = (signal_max-noise_avg)/noise_std;

SNR_t = snr/sqrt(expt);