function params = read_params_from_file_2(filetext, filetext1)
% Read flip angle, TR from file.
% ====================================
% TR
% ====
tr = strfind(filetext, '$D=');
TR = read_vector(filetext, tr);
params.TR = TR(11)*1e3;

% flip angle deg.
% =================
fa = strfind(filetext, '$CNST=');
FA = read_vector(filetext, fa);
params.FA = FA(11);

% read sw (spectral width), npoints and center frequency from file.
% ====================================================================
STR = {'$SW_h=', '$TD=', '$O1=', '$SFO1='};
Res = zeros(1, 4);
for J = 1:4
    ind = strfind(filetext, STR{J});
    ind = ind + length(STR{J});
    Res(J) = read_number(filetext, ind);
end
% read Nshift from acqu3.
% ==========================
STR = '$TD=';
ind = strfind(filetext1, STR);
ind = ind + length(STR);
Nshift = read_number(filetext1, ind);
params.sw = Res(1); params.npoints = Res(2); params.freq_read = Res(3); params.larmor_freq = Res(4);
params.Nshift = Nshift;

% read NS from acqus.
% ==========================
STR = '$NS='; 
ns = strfind(filetext,STR);
NS = read_number(filetext,ns);
params.NS = NS;

% read DS from acqus.
% ==========================
STR = '$DS='; 
ds = strfind(filetext,STR);
DS = read_number(filetext,ds);
params.DS = DS;

function out = read_vector(filetext, ind)
while strcmp(filetext(ind), ')') == 0
    ind = ind + 1;
end
bb = filetext(ind:end);
out = ones(1, 50);
j = 1;
str = [];
for k = 1:50
    if ~isnan(str2double(bb(k))) || strcmp(bb(k), '.') > 0
        str = [str, bb(k)];
    else
        if ~isempty(str) && ~isnan(str2double(str))
            out(j) = str2double(str);
            if j > 11
                break
            end
            j = j + 1;
            str = [];
        end
    end
end

function res = read_number(filetext, Dat)
str = [];
for m = 1:20
    tmp_str = filetext(Dat + m);
    if ~isnan(str2double(tmp_str)) || strcmp(tmp_str, '.') > 0 || strcmp(tmp_str, '-') > 0
        str = [str, tmp_str];
    elseif ~isempty(str)
        break
    end
end
res = str2double(str);
