function []=modify_proc_header(Path,paramName,new_values)

filename=[Path,filesep,'proc'];

%read the method file
fileID=fopen(filename,'r');
[~,~,machinefmt,~] = fopen(fileID);
if(fileID<0)
    warning('Fichier proc introuvable !');
else
    formatSpec = '%s%[^\n\r]';
    dataArray = textscan(fileID, formatSpec, 'Delimiter', '', 'WhiteSpace', '',  'ReturnOnError', false);
    %% Remove white space around all cell columns.
    dataArray{1} = dataArray{1};
    fclose(fileID);
end
clearvars fileID;

%clean-up the parameter name
pName=['##',strtrim(paramName),'='];

%find the position
pos_ind = zeros(1,size(dataArray{1,1},1));
for ind = 1:size(dataArray{1,1},1)
    pos_ind(1,ind) = numel(strfind(dataArray{1, 1}{ind, 1}, pName));
end
pos_param = find(pos_ind);

%% Write in array
if numel(strfind(dataArray{1, 1}{pos_param, 1}, 'OWNER'))
    pdata_dir_lin =  strrep(Path,filesep,'/');
    dataArray{1, 1}{pos_param, 1} = [pName num2str(new_values,'%d ')];
    dataArray{1, 1}{pos_param+2, 1} = ['$$ ' pdata_dir_lin '/proc'];
    txt_process = split(dataArray{1, 1}{pos_param+3, 1},'\');
    txt_process{end,1} = 'dataserver.exe';
    txt_process = join(txt_process,'\'); txt_process = txt_process{1,1};
    dataArray{1, 1}{pos_param+3, 1} = txt_process;
else
    dataArray{1, 1}{pos_param, 1} = [pName num2str(new_values,'%d ')];
end

%% Write new file
% warning off MATLAB:iofun:UnsupportedEncoding;
% fileID = fopen(filename, 'w', 'b', 'UTF16-LE');
fileID=fopen(filename,'w',machinefmt);
formatSpec = '%s\n';
for ind = 1:size(dataArray{1,1},1)
    fprintf(fileID,formatSpec,dataArray{1, 1}{ind, 1});
end
fclose(fileID);
end
