function [success] = my_silentPISSreco(directory)
%% define parameters
RF_phase = 0;% RF phase in deg.
L1_ini = 1;
T1 = 2000;
T2 = 1000;
sw_init = -2; % -2 kHz
sw_final = 2; % 2 kHz
sw_display = [sw_init, sw_final]*1e3;       % display bandwidth.
sw_target = abs(sw_init-sw_final)*1e3;
N1 = 2; % pts
NpointsZF = 16384; % pts
check_ssfp = false;       % check if ssfp is as expected. Use only for data with a single spectral line.
remove_dc = true;
down_samp = false;       % do not down sample.

figure_on_off = 0;

%% Perform reconstruction
% FISTA processing
% ====================
lambda = 0.0001;
Nskip = N1;
min_npoints = 70 + Nskip;
lines_to_skip = 30;
run_km_calib = false;
calc_method = 'fista';
n_phases = 3;
add_band = 0;
min_sw_Hz = sw_target;
sw_display_Hz = sw_display;

input_params = my_input_param(lambda,T1,T2,check_ssfp,remove_dc,Nskip,min_sw_Hz, ...
    min_npoints,lines_to_skip,run_km_calib, RF_phase, ...
    n_phases, add_band,sw_display_Hz);

[~,Spect,~,~] = my_process_Fista_spectrum(directory, input_params);
Spect = Spect'./(max(Spect)/1000);

%% save spectrum
% save original files
if ~isfolder([directory filesep 'pdata' filesep '1orig'])
    copyfile([directory filesep 'pdata' filesep '1'],[directory filesep 'pdata' filesep '1orig'],'f');
end
pdata_dir = [directory filesep 'pdata' filesep '1'];

% clean procno 1
warning('off','MATLAB:DELETE:FileNotFound')
delete([pdata_dir filesep 'proc2']);delete([pdata_dir filesep 'proc2s']);
delete([pdata_dir filesep 'proc3']);delete([pdata_dir filesep 'proc3s']);
delete([pdata_dir filesep 'proc4']);delete([pdata_dir filesep 'proc4s']);

% perform Zero filling if requiered
isZF = 1;
NpointsSpectOrig = size(Spect,2);
if isZF == 1 && size(Spect,2)<NpointsZF
    if mod(size(Spect,2),2) ==0
        shiftspect = (NpointsZF./size(Spect,2))-1;
        Kspace  = FFTXSpace2KSpace(Spect,2);
        padPoints = round((NpointsZF-size(Spect,2))/2);
        KspaceZF = padarray(Kspace,[0 padPoints],0,'both');
        Spect = FFTKSpace2XSpace(KspaceZF,2);
        Spect=abs(fineshift(Spect,[0 shiftspect]));
    else
        shiftspect = (NpointsZF./size(Spect,2))-1;
        Kspace  = FFTXSpace2KSpace(Spect,2);
        padPoints = round((NpointsZF-size(Spect,2))/2);
        KspaceZF = padarray(Kspace,[0 padPoints],0,'pre');
        KspaceZF = padarray(KspaceZF,[0 padPoints-1],0,'post');
        Spect = FFTKSpace2XSpace(KspaceZF,2);
        Spect=abs(fineshift(Spect,[0 shiftspect]));
    end
end

%% Write 1r and 1i files
NewR=fopen([pdata_dir filesep '1r'],'w+','l');
fwrite(NewR,Spect,'int32');
fclose(NewR);
NewI=fopen([pdata_dir filesep '1i'],'w+','l');
fwrite(NewI,zeros(size(Spect)),'int32');
fclose(NewI);

% read acqu file to retrieve parameters
acqu = read_acqu(directory);
Nucl =read_parArray(acqu,'NUC1');
SF =read_parArray(acqu,'SFO1');

% Get number of point min and max value of the spectrum
Npoints = size(Spect,2);
MinR = min(Spect);
MaxR = max(Spect);

% create Param files
create_outd(pdata_dir);
create_auditp(pdata_dir);
create_used_from(pdata_dir);

% modify proc and procs
modify_proc_header(pdata_dir,'NPOINTS',3);modify_procs_header(pdata_dir,'NPOINTS',2);
modify_proc_header(pdata_dir,'OWNER','nmrsu');modify_procs_header(pdata_dir,'OWNER','nmrsu');

modify_proc(pdata_dir,'PPARMOD',0); modify_procs(pdata_dir,'PPARMOD',0);
modify_proc(pdata_dir,'XDIM',0); modify_procs(pdata_dir,'XDIM',0);
modify_proc(pdata_dir,'YMAX_p',0);modify_procs(pdata_dir,'YMAX_p',num2str(MaxR));
modify_proc(pdata_dir,'YMIN_p',0);modify_procs(pdata_dir,'YMIN_p',num2str(MinR));
modify_proc(pdata_dir,'SI',Npoints);modify_procs(pdata_dir,'SI',Npoints);
modify_proc(pdata_dir,'STSI',Npoints);modify_procs(pdata_dir,'STSI',Npoints);
modify_proc(pdata_dir,'FTSIZE',Npoints);modify_procs(pdata_dir,'FTSIZE',Npoints);
modify_proc(pdata_dir,'TDeff',NpointsSpectOrig);modify_procs(pdata_dir,'TDeff',NpointsSpectOrig);
modify_proc(pdata_dir,'AXUNIT',' <>');modify_procs(pdata_dir,'AXUNIT',' <>');
modify_proc(pdata_dir,'AXNAME',' <>');modify_procs(pdata_dir,'AXNAME',' <>');
modify_proc(pdata_dir,'AXLEFT',0);modify_procs(pdata_dir,'AXLEFT',0);
modify_proc(pdata_dir,'AXRIGHT',0);modify_procs(pdata_dir,'AXRIGHT',0);
modify_proc(pdata_dir,'SW_p',sw_target);modify_procs(pdata_dir,'SW_p',sw_target);
modify_proc(pdata_dir,'AXNUC',Nucl);modify_procs(pdata_dir,'AXNUC',Nucl);
modify_proc(pdata_dir,'SF',SF);modify_procs(pdata_dir,'SF',SF);
modify_proc(pdata_dir,'PH_mod',2);modify_procs(pdata_dir,'PH_mod',2); % Magnitude
modify_proc(pdata_dir,'BC_mod',2);modify_procs(pdata_dir,'BC_mod',2);
modify_proc(pdata_dir,'FCOR',1);modify_procs(pdata_dir,'FCOR',1);
modify_proc(pdata_dir,'FT_mod',6);modify_procs(pdata_dir,'FT_mod',6);
modify_proc(pdata_dir,'NC_proc',-20);modify_procs(pdata_dir,'NC_proc',-20);
modify_proc(pdata_dir,'PKNL','yes');modify_procs(pdata_dir,'PKNL','yes');

modify_title(pdata_dir,T1,T2,sw_target,N1,NpointsZF,remove_dc);

my_box = msgbox("PISS reconstruction completed","Success");

success = 1;
end
