function []=create_auditp(pdata_dir,Npoints)

filename=[pdata_dir,filesep,'auditp.txt'];
%% read the  file
% fileID=fopen(filename,'r');
% [~,~,machinefmt,~] = fopen(fileID);
% formatSpec = '%s%[^\n\r]';
% dataArray = textscan(fileID, formatSpec, 'Delimiter', '', 'WhiteSpace', '',  'ReturnOnError', false);
% %% Remove white space around all cell columns.
% dataArray{1} = dataArray{1};
% fclose(fileID);
% clearvars fileID;

pdata_dir_lin =  strrep(pdata_dir,filesep,'/');

dataArray{1,1} = {'##TITLE= Audit trail, TopSpin 4.3.0';...
    '##JCAMPDX= 5.01';...
    '##ORIGIN= Bruker BioSpin GmbH';...
    '##OWNER= User';...
    ['$$ ' pdata_dir_lin '/3/auditp.txt'];...
    '##AUDIT TRAIL=  $$ (NUMBER, WHEN, WHO, WHERE, PROCESS, VERSION, WHAT)';...
    '(   1,<2023-09-11 13:33:29.365 +0300>,<nmrsu>,<CZC8508V38>,<go4>,<TopSpin 3.6.1>,';...
    '      <created by zg';['' char(9) 'started at 2023-09-11 13:31:51.715 +0300,'];...
    ['' char(9) 'POWCHK enabled, PULCHK disabled,'];...
    '       configuration hash MD5:';...
    '       6D 6F 4F DF 2C 43 DE 34 FF 81 C3 8E 7C 98 B3 BD';...
    '       data hash MD5: 2K * 400 * 40 * 1';...
    '       55 94 A6 12 3B 10 4A 76 45 2A E8 2B 9F BC 3B 12>)';...
    '(   2,<2023-12-14T14:59:38.125+0100>,<User>,<PC-Max>,<proc1d>,<TopSpin 4.3.0>,';...
    '      <Start of raw data processing';...
    '       ft 1 BC_mod = 2 FT_mod = 6 PKNL = 1 SI = 128 ';...
    '       data hash MD5: 128';...
    '       0E 0A 3C 29 50 89 FA 34 12 03 EE 9C 8F 2C C5 08>)';...
    '##END=';...
    '$$ hash MD5';...
    '$$ E1 6E 1E 29 2E FA F7 01 B3 FE C7 30 BE E7 D8 EF'};

machinefmt = 'ieee-le';

%% Write new file
% warning off MATLAB:iofun:UnsupportedEncoding;
% fileID = fopen(filename, 'w', 'b', 'UTF16-LE');
fileID=fopen(filename,'w',machinefmt);
formatSpec = '%s\n';
for ind = 1:size(dataArray{1,1},1)
    fprintf(fileID,formatSpec,dataArray{1, 1}{ind, 1});
end
fclose(fileID);
end


