function []=modify_title(Path,T1,T2,sw_target,N1,NpointsZF,remove_dc,lambda)

filename=[Path,filesep,'title'];

%read the method file
fileID=fopen(filename,'r');
[~,~,machinefmt,~] = fopen(fileID);
if(fileID<0)
    warning('Fichier title introuvable !');
else
    formatSpec = '%s%[^\n\r]';
    dataArray = textscan(fileID, formatSpec, 'Delimiter', '', 'WhiteSpace', '',  'ReturnOnError', false);
    %% Remove white space around all cell columns.
    dataArray{1} = dataArray{1};
    fclose(fileID);
end
clearvars fileID;

%find the position
pos_ind = zeros(1,size(dataArray{1,1},1));
for ind = 1:size(dataArray{1,1},1)
    pos_ind(1,ind) = numel(strfind(dataArray{1, 1}{ind, 1}, 'Spectrum reconstructed by'));
end
pos_param = find(pos_ind);
if isempty(pos_param) % below already existing text
    pos_param = size(dataArray{1, 1},1)+1;
end


%% Write in array
dataArray{1, 1}{pos_param, 1} = 'Spectrum reconstructed by my_PISS NMR processor';
dataArray{1, 1}{pos_param+1, 1} = ['T1 = ' num2str(T1,'%d ') ' ms'];
dataArray{1, 1}{pos_param+2, 1} = ['T2 = ' num2str(T2,'%d ') ' ms'];
dataArray{1, 1}{pos_param+3, 1} = ['Swh = ' num2str(sw_target,'%d ') ' Hz'];
dataArray{1, 1}{pos_param+4, 1} = ['TDoff = ' num2str(N1,'%d ') ' pts'];
dataArray{1, 1}{pos_param+5, 1} = ['SI = ' num2str(NpointsZF,'%d ') ' pts'];
if remove_dc==1
    dataArray{1, 1}{7, 1} = 'offset correction = true';
else
    dataArray{1, 1}{7, 1} = 'offset correction = false';
end
dataArray{1, 1}{pos_param+8, 1} = ['Lambda = ' num2str(lambda,'%d ')];

%% Write new file
% warning off MATLAB:iofun:UnsupportedEncoding;
% fileID = fopen(filename, 'w', 'b', 'UTF16-LE');
fileID=fopen(filename,'w',machinefmt);
formatSpec = '%s\n';
for ind = 1:size(dataArray{1,1},1)
    fprintf(fileID,formatSpec,dataArray{1, 1}{ind, 1});
end
fclose(fileID);
end
