#!/bin/csh

#initialisation

#PKG_PATH=$(pwd);

PKG_PATH=$(dirname $0);

clear;
echo "********************************************************************************";
echo "The script will install the SPENss method and dependencies on your VNMRJ system";
echo "System requirements: Linux 32 or 64 bits (64 bits recommended)";
echo "Software requirements: Agilent@VNMRJ3.2";
echo "Contact zhiyong.zhang@weizmann.ac.il or zhiyongxmu@gmail.com";
echo "********************************************************************************";
#echo "Please press [Enter] ..."; read -p "";

echo "Checking matlab compiler runtime(MCR) environment"

MRC_PATH=$(locate -w '/MATLAB/MATLAB_Compiler_Runtime/v82' -l 1);

if [ -z "$MRC_PATH" ]; then
   echo "Unfortunately, no MRC v82 enviroment is detected";
   echo "Install the Matlab Compiler Runtimes ...";
   echo "You need root permition to install it in systemdir or please intall it in the userdir ..."
   
   if [ ! -f "$PKG_PATH/mcr/MCR_R2013b_glnxa64_installer.zip" ]; then
     URL_MCRv82="http://www.mathworks.com/supportfiles/downloads/R2013b/deployment_files/R2013b/installers/glnxa64/MCR_R2013b_glnxa64_installer.zip";
     echo "Downloading Matlab Compiler Runtimes ..."
     mkdir -p "$PKG_PATH/mcr/";
     cd "$PKG_PATH/mcr/"
     wget -c "$URL_MCRv82";
   fi
     cd "$PKG_PATH/mcr/"
     unzip "$PKG_PATH/mcr/MCR_R2013b_glnxa64_installer.zip" -d "mcrinstalltemp";
     cd "$PKG_PATH/mcr/mcrinstalltemp/";
     su -c "./install -inputFile mcrinstalltemp";
     echo "You need update the mlocatedb using root permition";
     su -c "updatedb";
     rm -rf "$PKG_PATH/mcr/mcrinstalltemp"
fi

MRC_PATH=$(locate -w '/MATLAB/MATLAB_Compiler_Runtime/v82' -l 1);

if [ -z "$MRC_PATH" ]; then
   echo "MATLAB_Compiler_Runtime install fail"
   exit;
else
   echo "$MRC_PATH is detected";
fi

echo $MRC_PATH

#check system architecture
#clear
echo "                                                                                ";
echo "Checking the operating system ..."
while true
do 
case "$(uname -m)" in
  "x86_64") echo "Linux 64 bits system detected ...";
   break;;
   *) echo "Error: The SPENss method requires 64 bits Linux system (RedHat Enterprise or CentOS recommend).";
   exit;
   break;;
esac
done
echo "                                                                                ";

#echo "Please press [Enter] ..."; read -p "";


echo "                                                                                ";
echo "Copying files ..."
mkdir -p "/home/$USER/vnmrsys/templates/layout/SPENss";
mkdir -p "/home/$USER/vnmrsys/templates/vnmrj/protocols";
mkdir -p "/home/$USER/vnmrsys/parlib/SPENss.par";
mkdir -p "/home/$USER/vnmrsys/wavelib/decoupling";

#touch "/home/$USER/vnmrsys/pulsecal";
if [ ! -e "/home/$USER/vnmrsys/pulsecal" ]; then
   if [ -e "/vnmr/pulsecal" ]; then
     cp -f "/vnmr/pulsecal" "/home/$USER/vnmrsys/";
   else
     echo "pulsecal is not exsited in /home/$USER/vnmrsys/pulsecal, Errors for power caculation";
     exit;
   fi
fi

echo "                                                                                ";

cp -f "$PKG_PATH/SPENss/acq.xml" "/home/$USER/vnmrsys/templates/layout/SPENss/";
cp -f "$PKG_PATH/SPENss/acqAdv.xml" "/home/$USER/vnmrsys/templates/layout/SPENss/";
cp -f "$PKG_PATH/SPENss/acqGradients.xml" "/home/$USER/vnmrsys/templates/layout/SPENss/";
cp -f "$PKG_PATH/SPENss/acqOptions.xml" "/home/$USER/vnmrsys/templates/layout/SPENss/";
cp -f "$PKG_PATH/SPENss/acqPrescan.xml" "/home/$USER/vnmrsys/templates/layout/SPENss/";
cp -f "$PKG_PATH/SPENss/acqWS.xml" "/home/$USER/vnmrsys/templates/layout/SPENss/";
cp -f "$PKG_PATH/SPENss/acqScan.xml" "/home/$USER/vnmrsys/templates/layout/SPENss/";

cp -f "$PKG_PATH/SPENss/SPENss.xml" "/home/$USER/vnmrsys/templates/vnmrj/protocols/";
cp -f "$PKG_PATH/SPENss/SPENss" "/home/$USER/vnmrsys/seqlib/";
cp -f "$PKG_PATH/SPENss/SPENss.c" "/home/$USER/vnmrsys/seqlib/";
cp -f "$PKG_PATH/SPENss/SPENss.c" "/home/$USER/vnmrsys/psglib/";
cp -f "$PKG_PATH/SPENss/SPENssmac" "/home/$USER/vnmrsys/maclib/";
cp -f "$PKG_PATH/SPENss/recoverFID" "/home/$USER/vnmrsys/maclib/";
cp -f "$PKG_PATH/SPENss/recon/run_SPENssrecon.sh" "/home/$USER/vnmrsys/maclib/";
cp -f "$PKG_PATH/SPENss/recon/SPENssrecon" "/home/$USER/vnmrsys/maclib/";

cp -f "$PKG_PATH/SPENss/procpar" "/home/$USER/vnmrsys/parlib/SPENss.par/";
cp -f "$PKG_PATH/SPENss/text" "/home/$USER/vnmrsys/parlib/SPENss.par/";
cp -f "$PKG_PATH/SPENss/WURST180" "/home/$USER/vnmrsys/wavelib/decoupling/";
cp -f "$PKG_PATH/SPENss/recon/run_SPENssrecon.sh" "/home/$USER/vnmrsys/templates/layout/SPENss/";
cp -f "$PKG_PATH/SPENss/recon/SPENssrecon" "/home/$USER/vnmrsys/templates/layout/SPENss/";
echo "finish copying files ..."

echo "                                                                                ";
echo "********************************************************************************";
echo "The SPENss method is now installed!:)";
echo "In order to run the SPENss protocol, please close VNMRJ and reopen it";
echo "Contact zhiyong.zhang@weizmann.ac.il or zhiyongxmu@gmail.com for support";
echo "********************************************************************************";



