function spins = PurgeJ(spins, duration, k)
% The current function applies a hard pulse to a J-coupled spin structure.
% The field's strength is calibrated according to Protons.
%
% Input:
%
% Variable Name    Units         Description
% spins            -             J-coupled spin array
% duration         ms            Delay
% k                m^(-1)        k-Space moments along x, y, z, assuming
%                                protons

numNuclei = numel(spins.csVec);
affectedNuclei = ones(1, numNuclei);

if (nargin<4)
    isSecular = 1;
end

% Calculate the required gradients during the encoding period to 
% achieve the desired k-space moment
gradient = k./spins.gmRatio(1)/duration; % mT/m

pulse.tp = duration; % ms
pulse.RFamp = 0; % in microtesla
pulse.RFphase = 0;
pulse.Gx = gradient(1); % mT/m
pulse.Gy = gradient(2); % mT/m
pulse.Gz = gradient(3); % mT/m

isAcquire = 0;
[~, spins] = PropagateJ(spins, pulse, affectedNuclei, isAcquire);