% Spectroscopic Simulation Tool: Spin object
% Encapsulates a single molecule in a J-coupled Hamiltonian with
% relaxation.
classdef SSTMolecule
    properties    
        nucleus              % 1xnumSpins cell array of nuclei
        pos                  % 1x3 vector containing molecule's position in mm
        rho                  % Density matrix of spin system
        cs                   % 1xnumSpins vector of spins' chemical shifts in ppm (in rot. frame)
        eqMag                % 1xnumSpins vector of spins' equilibrium magnetization (M0)
    end
    properties (Dependent)
        numSpins
        gmRatio              % 1xnumSpins vector of spins' gyromagnetic ratios, in kHz/mT
        spin                 % 1xnumSpins vector of spins' 
        natAbun
    end
    methods
        function obj = SSTMolecule(varargin)
            p = inputParser;
            p.addParameter('pos', [0 0 0], @(x) validateattributes(x, {'double'}, {'ncols', 3}));
            p.addParameter('rho', [], @(x) validateattributes(x, {'double'}, {'ncols', 3}));
            p.addParameter('cs', 0, @(x) validateattributes(x, {'double'}, {'size', [1 1]}));
            p.addParameter('eqMag', 1, @(x) validateattributes(x, {'double'}, {'size', [1 1]}));
            p.addParameter('nucleus', {'1h'}, @(x) iscell(x));
            p.parse(varargin{:});
            
            obj.pos = p.Results.pos;
            obj.rho = p.Results.rho;
            obj.cs = p.Results.cs;
            obj.eqMag = p.Results.eqMag;

            if isempty(obj.rho)
                obj.Boltzmann; 
            end
        end
        
        function numSpins = get.numSpins(obj)
            numSpins = numel(obj.nucleus);
        end
        
        function gmRatio = get.gmRatio(obj)
            gmRatio = zeros(1, obj.numSpins);
            for idx=1:obj.numSpins
                switch lower(obj.nucleus{idx})
                    case '1h'
                        gmRatio(idx) = 42.576;
                    case '13c'
                        gmRatio(idx) = 10.708;
                    case '31p'
                        gmRatio(idx) = 17.254;
                    case '19f'
                        gmRatio(idx) = 40.077;
                    otherwise
                        error('Unrecognized nucleus %s in SSTMolecule object.', obj.nucleus{idx});
                end
            end
        end

        function spin = get.spin(obj)
            spin = zeros(1, obj.numSpins);
            for idx=1:obj.numSpins
                switch lower(obj.nucleus{idx})
                    case {'1h', '13c', '31p', '19f'}
                        spin(idx) = 1/2;
                    otherwise
                        error('Unrecognized nucleus %s in SSTMolecule object.', obj.nucleus{idx});
                end
            end
        end
        
        function natAbun = get.natAbun(obj)
            natAbun = zeros(1, obj.numSpins);
            for idx=1:obj.numSpins
                switch lower(obj.nucleus{idx})
                    case '1h'
                        natAbun(idx) = 0.9998;
                    case '13c'
                        natAbun(idx) = 0.01108;
                    case '31p'
                        natAbun(idx) = 1.0;
                    case '19f'
                        natAbun(idx) = 1.0;
                    otherwise
                        error('Unrecognized nucleus %s in SSTMolecule object.', obj.nucleus{idx});
                end
            end
        end
        
        function Boltzmann(obj)
            for idx=1:obj.numSpins
                bolztmannFactor(idx) = 
            end
        end

        function iz = Iz(obj, idxSpin)
            M = IzN(idx, numNuclei)

            if (idx==1)
                M = Iz;
            else
                M = I;
            end

            for k=2:numNuclei
                if (k==idx)
                    M = kron(M,Iz);
                else
                    M = kron(M,I);
                end
            end            
        end
        
    end
end