function gmr = GetGyromagneticRatio(nucleus)
% gmr = GetGyromagneticRatio(nucleus)
% 
% Returns the gyromagnetic ratio of the given nucleus over 2 pi in kHz/mT.
% Nucleus is defined via a string. Possible values:
% '1H', '13C', 31P'
% Omitting it will default to protons.

if nargin<1
    nucleus = '1h';
end
nucleus = lower(nucleus);

switch nucleus
    case '1h'
        gmr = 42.5774806;
    case '13c'
        gmr = 10.705;
    case '31p'
        gmr = 17.235;
    case '2h'
        gmr = 6.536;
    case '17o'
        gmr = 5.772;
    otherwise
        error('Unrecognized nucleus %s \n', nucleus);
end