function spins = InitSpinsExchange(chemShiftVec, ...
                                   exchangeMatrix, ...
                                   initialMag, ...
                                   T1, ...
                                   T2, ...
                                   eqMag, ...
                                   B1Scaling, ...
                                   receiverSensitivity)
%   spins = InitSpinsExchange(
%
%   The current function creates a 1D spin structure with no J coupling, to
%   which pulses, delays, etc. can be acurSpinlied using AcurSpinlyPulseRelax, etc.
%
%   Inputs 
%
%   Name              Type         Units   Description      
%   chemShiftVec      1xN double   kHz     Vector of chemical shifts
%   numSpinsPerShift  double       -       # of spins per chemical shift
%   sampleSize        double       mm      Size of sample
%   initialMag        3x1 double   -       Initial magnetization
%   T1                double       ms      Longitudinal relaxation
%   T2                double       ms      Transverse relaxation
%   eqMag             double       -       Equilibrium magnetization (M0)
%   B1                double       -       B1 scaling factor
%
%   Example:
%   spins = InitSpinsRelax(0, 100, 100, [0; 0; 1], 1000, 200, 1);

if nargin<3, initialMag = [0; 0; 1]; end
if nargin<4, T1 = 1e9; end
if nargin<5, T2 = 1e9; end
if nargin<6, eqMag = 1; end
if nargin<7, B1Scaling = 1; end
if nargin<8, receiverSensitivity = 1; end

numSites = size(exchangeMatrix, 1);

spins(1).r = [0; 0; 0];
if numel(initialMag)==3
    spins(1).M = repmat(initialMag, numSites, 1);
else
    spins(1).M = initialMag;
end
spins(1).cs = chemShiftVec;
spins(1).T1 = T1;
spins(1).T2 = T2;
spins(1).M0 = eqMag;
spins(1).B1 = B1Scaling;
spins(1).RS = receiverSensitivity;
spins(1).K = exchangeMatrix;

