function [av_width, error1]=calc_plot_mean_gap_width_fluorescence(filename,th_level,st_size,ob_size_th1,ob_size_th2,std4_th,max_width,font_size, flag_save_images)

av_width=nan;
error1='';

flag_t0=~isempty(strfind(filename,'_0h_'));

I = imread(filename);

if max_width>size(I,2)
    error1=['max window width cannot be larger than width of ' filename];
    return
end

if ndims(I)==3
    I=rgb2gray(I);
end
[N,M]=size(I);
% figure;
% imshow(I);


% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
% background = imopen(I,strel('disk',15));
%     I2 = I - background;
    I3 = I;%imadjust(I2);
    level= graythresh(I3);
    IBW = im2bw(I3, th_level*level);
    % figure;
    % imshow(IBW);
    
    borders=[round(length(IBW(:,1))*0.15),round(length(IBW(:,1))*0.85)];
    IBW=IBW(borders(1):borders(2),:);
    
    IBW = imfill(IBW,'holes');
    IBW = medfilt2(IBW, st_size*[1,1]);
    se = strel('disk',st_size);
    IBW = imclose(IBW,se);
    IBW = imfill(IBW,'holes');
    
    
    
    IBW = bwareaopen(IBW, ob_size_th1);
    % figure;
    % imshow(IBW);
    
    IBW = medfilt2(IBW, st_size*[2,2]);
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 


se = strel('disk',st_size);
IBW = imclose(IBW,se);
% figure;
% imshow(IBW);

IBW = imfill(IBW,'holes');
% figure;
% imshow(IBW);

IBW = bwareaopen(IBW, ob_size_th2);
% figure;imshow(IBW);
% imshow(IBW);

midlle_subframe=IBW;
IBW=[false(borders(1)-1,M);IBW;false(N-borders(2),M)];
sumblack_col=sum(midlle_subframe==0);
indmat=repmat([1:max_width]',1,M-max_width-1)+repmat([0:M-max_width-2],max_width,1);
windowsum=sum(sumblack_col(indmat));
[blackarea,midgap_start]=max(windowsum);
if sum(windowsum==blackarea)>1
    midgap_start=round((find(windowsum==blackarea,1,'first')+find(windowsum==blackarea,1,'last'))/2);
end
    
% blackarea=sum(midlle_subframe(:)==0);
av_width=blackarea/length(midlle_subframe(:,1));

midlle_subframe2=midlle_subframe(:,midgap_start:midgap_start+max_width);
bw= edge(midlle_subframe2);

if flag_t0
    edge_x=cell(length(midlle_subframe2(:,1)),1);
    for i=1:length(midlle_subframe2(:,1))
        edge_x{i}=find(bw(i,:)==1);
    end
    yy=cellfun(@length,edge_x);
    % figure;
    % hist(yy)
    if std(yy)>1
        h=floor(length(midlle_subframe2(:,1))/10);
        tmp=midlle_subframe2(1:1+h-1,:);
        blackarea=sum(tmp(:)==0);
        av_width_vec(1)=blackarea/h;
        for jj=2:10
            tmp=midlle_subframe2(1+h*(jj-1):jj*h,:);
            blackarea=sum(tmp(:)==0);
            av_width_vec(jj)=blackarea/h;
        end
        if std(av_width_vec)>std4_th
            av_width=nan;
        end
    end
end

if ~flag_save_images
    return;
end


% % % % % % % % % % % % % % % % % % % % % 


IBW=[false(borders(1)-1,M);[false(length(midlle_subframe2(:,1)),midgap_start-1)...
    ,midlle_subframe2,false(length(midlle_subframe2(:,1)),M-midgap_start-max_width)];false(N-borders(2),M)];
% font_size=4;
B = bwboundaries(IBW);
bw= edge(IBW);
% se = strel('disk',5);
% bw=imdilate(bw,se);
% hf=figure;
% set(hf,'color','w','PaperPositionMode','auto')
% overlay2 = imoverlay(I, bw , get_RGB('green'));
% imshow(overlay2);hold on;
%set(gcf,'position',[200 200 size(I,2) size(I,1)]);
imshow(I,'border','tight');
%set(gcf,'PaperPositionMode','auto');
hold on;
for i=1:length(B)
    plot(B{i}(:,2),B{i}(:,1),'g','linewidth',2);
end
axis tight
plot([midgap_start,midgap_start+max_width],borders(1)*[1,1],'r','linewidth',1);
plot([midgap_start,midgap_start+max_width],(borders(2)+1)*[1,1],'r','linewidth',1);
plot(midgap_start*[1,1],borders,'r','linewidth',1);
plot((midgap_start+max_width)*[1,1],borders,'r','linewidth',1);
ymid=round(borders(1)+diff(borders)/2);
x=find(bw(ymid,:));
if isempty(x)
    x=find(bw(borders(1)+5,:));
    ymid=borders(1)+5;
end
if isempty(x)
    x=round([M/2-20,M/2-20]);
end
plot(x,ones(length(x),1)*ymid,'m','linewidth',2)
ht=text(mean(x),ymid,['Average width=',num2str(av_width)]);
set(ht,'fontsize',font_size,'FontWeight','demi','Color','y','HorizontalAlignment','center','VerticalAlignment','bottom');
tstring=regexprep(filename,'_','-');
[~, tstring]=fileparts(tstring);
% k=strfind(tstring,'/');
% if ~isempty(k)
%     tstring=tstring(k(end)+1:end);
% end
ht=text(mean(x),15,tstring);
set(ht,'fontsize',font_size,'FontWeight','demi','Color','r','HorizontalAlignment','center','VerticalAlignment','top','BackgroundColor','y');
% saveas(hf,['analysis_amit/',filename(1:end-5),'_results_amit.png']);

% toc



