function [av_width, error1]=calc_plot_mean_gap_width_phase_contrast(filename,th_level,st_size,ob_size_th1,ob_size_th2,std4_th,max_width,font_size, flag_save_images)

if ~mod(st_size,2)
    st_size=st_size-1;
end

av_width=nan;
error1='';

flag_t0=~isempty(strfind(filename,'_0h_'));

I_orig = imread(filename);

if max_width>size(I_orig,2)
    error1=['max window width cannot be larger than width of ' filename];
    return
end


I_orig2=I_orig;
% 
% st_size=5;
% th_level=0.3;
% ob_size_th1=1000;
% ob_size_th2=2000;
% I=imread('a40.jpg');
if ndims(I_orig)==3
    I_orig=rgb2gray(I_orig);
end
I_orig=imadjust(255-I_orig);
background = imopen(I_orig,strel('disk',30));
I_orig = I_orig - background;
I_orig=imadjust(I_orig);   

% J= wiener2(I_orig, st_size*[1,1]);
%imshow(J);
I=stdfilt(I_orig,ones(st_size));
I=imadjust(uint16(I));
%imshow(I);
J= wiener2(I, st_size*[1,1]);
%imshow(J);
level= graythresh(J);
IBW = im2bw(J, th_level*level);
%imshow(IBW);
IBW(:,1)=true;IBW(:,end)=true;
IBW = imfill(IBW,'holes');
%imshow(IBW);
se = strel('disk',st_size);
IBW = imclose(IBW,se);
%imshow(IBW);
IBW = imfill(IBW,'holes');
%imshow(IBW);
IBW = medfilt2(IBW,st_size*[1,1]);
%imshow(IBW);
IBW = bwareaopen(IBW, ob_size_th1);
%imshow(IBW);
IBW = imclose(IBW,se);
%imshow(IBW);
IBW = bwareaopen(IBW, ob_size_th2);
%imshow(IBW);
IBW = imfill(IBW,'holes');
%imshow(IBW);




[N,M]=size(I);




%     I3 = I;%imadjust(I2);
%     level= graythresh(I3);
%     IBW = im2bw(I3, th_level*level);
%     
%     
    borders=[round(length(IBW(:,1))*0.15),round(length(IBW(:,1))*0.85)];
    IBW=IBW(borders(1):borders(2),:);
%     
%     IBW = bwareaopen(IBW, ob_size_th1);
%     
%     IBW = imfill(IBW,'holes');
%     IBW = medfilt2(IBW, st_size*[1,1]);
%     se = strel('disk',st_size);
%     IBW = imclose(IBW,se);
%     IBW = imfill(IBW,'holes');
%     
%     
%     
%     IBW = bwareaopen(IBW, ob_size_th1);
%     
%     
%     IBW = medfilt2(IBW, st_size*[2,2]);
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
% 
% 
% se = strel('disk',st_size);
% IBW = imclose(IBW,se);
% 
% 
% IBW = imfill(IBW,'holes');
% 
% 
% IBW = bwareaopen(IBW, ob_size_th2);


midlle_subframe=IBW;
%IBW=[false(borders(1)-1,M);IBW;false(N-borders(2),M)];
sumblack_col=sum(midlle_subframe==0);
indmat=repmat([1:max_width]',1,M-max_width-1)+repmat([0:M-max_width-2],max_width,1);
windowsum=sum(sumblack_col(indmat));
[blackarea,midgap_start]=max(windowsum);
if sum(windowsum==blackarea)>1
    midgap_start=round((find(windowsum==blackarea,1,'first')+find(windowsum==blackarea,1,'last'))/2);
end
    

av_width=blackarea/length(midlle_subframe(:,1));

midlle_subframe2=midlle_subframe(:,midgap_start:midgap_start+max_width);
bw= edge(midlle_subframe2);

if flag_t0
    edge_x=cell(length(midlle_subframe2(:,1)),1);
    for i=1:length(midlle_subframe2(:,1))
        edge_x{i}=find(bw(i,:)==1);
    end
    yy=cellfun(@length,edge_x);
    
    if std(yy)>1
        h=floor(length(midlle_subframe2(:,1))/10);
        tmp=midlle_subframe2(1:1+h-1,:);
        blackarea=sum(tmp(:)==0);
        av_width_vec(1)=blackarea/h;
        for jj=2:10
            tmp=midlle_subframe2(1+h*(jj-1):jj*h,:);
            blackarea=sum(tmp(:)==0);
            av_width_vec(jj)=blackarea/h;
        end
        if std(av_width_vec)>std4_th
            av_width=nan;
        end
    end
end

if ~flag_save_images
    return;
end


% % % % % % % % % % % % % % % % % % % % % 


IBW=[false(borders(1)-1,M);[false(length(midlle_subframe2(:,1)),midgap_start-1)...
    ,midlle_subframe2,false(length(midlle_subframe2(:,1)),M-midgap_start-max_width)];false(N-borders(2),M)];
B = bwboundaries(IBW);
bw= edge(IBW);
% se = strel('disk',3);
% bw=imdilate(bw,se);

% overlay2 = imoverlay(I_orig2, bw , get_RGB('green'));
% imshow(overlay2);
imshow(I_orig2,'border','tight') ;
hold on;
for i=1:length(B)
    plot(B{i}(:,2),B{i}(:,1),'g','linewidth',2);
end
hold on;
%axis tight
plot([midgap_start,midgap_start+max_width],borders(1)*[1,1],'r','linewidth',1);
plot([midgap_start,midgap_start+max_width],(borders(2)+1)*[1,1],'r','linewidth',1);
plot(midgap_start*[1,1],borders,'r','linewidth',1);
plot((midgap_start+max_width)*[1,1],borders,'r','linewidth',1);
ymid=round(borders(1)+diff(borders)/2);
x=find(bw(ymid,:));
if isempty(x)
    x=find(bw(borders(1)+5,:));
    ymid=borders(1)+5;
end
if isempty(x)
    x=round([M/2-20,M/2-20]);
end
%plot(x,ones(length(x),1)*ymid,'m','linewidth',2)
ht=text(max_width/2,100,['Average width=',num2str(av_width)]);
set(ht,'fontsize',font_size,'FontWeight','demi','Color','y','HorizontalAlignment','center','VerticalAlignment','bottom');
tstring=regexprep(filename,'_','-');
[~, tstring]=fileparts(tstring);

ht=text(max_width/2,15,tstring);
set(ht,'fontsize',font_size,'FontWeight','demi','Color','r','HorizontalAlignment','center','VerticalAlignment','top','BackgroundColor','y');




