function Rpath=FindRpath
% This function finds the path for the installed R (Project for Statistical Computing) in Windows environment.
% Only works in Windows environments.
% e.g.:
% Rpath=FindPathR
% >> 'C:\Program Files\R\R-3.1.1\bin'
% Weirong Chen   March-8-2015
sep = filesep; env=myGetEnv; 
a=FindWhich(env(:,1),'ProgramFiles');
b=FindWhich(env(:,1),'ProgramW6432'); 
c=FindWhich(env(:,1),'ProgramFiles(x86)');
n=[a;b;c]; isfound=0;
 for i=1:length(n)
     programPath=env{n(i),2};
     D=dir([programPath filesep 'R']);
     if ~isempty(D),
         A={D.name}; B=find(cell2mat(cellfun(@(s) ~isempty(strfind(s,'R-')),A,'uniformoutput',0)),1);
         if ~isempty(B),  isfound=1;Rpath=[programPath sep 'R' sep A{B} sep 'bin'];break; end;
     end%
 end;
if isfound==0,  Rpath=[];end;
end % end of main function
%
%
%
%% required sub-functions :

function env=myGetEnv
% Get the environmental values from the operation system.
% Returns key-value pairs stored in 'env' cell array.
% e.g.:
%  >> env=myGetEnv;
% >>  env{8,1} =  'ProgramFiles'
%  >> env{8,2} =  'C:\Program Files'
% Weirong Chen  March-8-2015
envmap = java.lang.System.getenv();
envkey=cell(envmap.keySet.toArray);
envvalue=cell(envmap.values.toArray);
env=[envkey envvalue];
end % end of function

function n=FindWhich(StringCellArray, TargetString)
% This funcion finds the 'TargetString' in a string cell array and returns
% the serial number of the element found in 'StringCellArray'.
% Weirong Chen    SEP-14-2013

sn=1:length(StringCellArray);
A=cellismember(StringCellArray,TargetString);
n=sn(A);
end % FindWhich

function Lia=cellismember(A,B) 
%  Lia=cellismember(A,B) ;
% 'cellismember' is a function that performs 'ismember' on string cells.
%  This function differs from 'ismember' in that this function can cope
%  with NaN value for string comparison.
%  N.B.: input A and B must be cells.
%
% Weirong Chen   DEC-22-2013
if ischar(B), B={B};end;
nanA=cellfun(@isnan, A, 'UniformOutput',false);
nanA=logical(cellfun(@sum, nanA));
A(nanA)={'This Cell is An NaN. '};

nanB=cellfun(@isnan, B, 'UniformOutput',false);
nanB=logical(cellfun(@sum, nanB));
B(nanB)={'This Cell is An NaN. '};

Lia=ismember(A,B);
end